/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static Class[] PRIMITIVE_CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final char PACKAGE_SEPARATOR_CHAR = '.';
    private static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    private static final String CGLIB_CLASS_SEPARATOR_CHAR = "$$";

    public static Class forName(String name) throws ClassNotFoundException {
        return ClassUtils.forName(name, Thread.currentThread().getContextClassLoader());
    }

    public static Class forName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = Class.forName(elementClassName, true, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        return Class.forName(name, true, classLoader);
    }

    public static Class resolvePrimitiveClassName(String name) {
        if (name.length() <= 8) {
            for (int i = 0; i < PRIMITIVE_CLASSES.length; ++i) {
                Class clazz = PRIMITIVE_CLASSES[i];
                if (!clazz.getName().equals(name)) continue;
                return clazz;
            }
        }
        return null;
    }

    public static String getShortNameAsProperty(Class clazz) {
        return StringUtils.uncapitalize(ClassUtils.getShortName(clazz));
    }

    public static String getShortName(Class clazz) {
        return ClassUtils.getShortName(clazz.getName());
    }

    public static String getShortName(String className) {
        Assert.hasLength(className, "class name must not be empty");
        int lastDotIndex = className.lastIndexOf(46);
        int nameEndIndex = className.indexOf(CGLIB_CLASS_SEPARATOR_CHAR);
        if (nameEndIndex == -1) {
            nameEndIndex = className.length();
        }
        String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
        shortName = shortName.replace('$', '.');
        return shortName;
    }

    public static String getQualifiedMethodName(Method method) {
        Assert.notNull(method, "Method must not be empty");
        return method.getDeclaringClass().getName() + "." + method.getName();
    }

    public static int getMethodCountForName(Class clazz, String methodName) {
        int count = 0;
        do {
            for (int i = 0; i < clazz.getDeclaredMethods().length; ++i) {
                Method method = clazz.getDeclaredMethods()[i];
                if (!methodName.equals(method.getName())) continue;
                ++count;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return count;
    }

    public static boolean hasAtLeastOneMethodWithName(Class clazz, String methodName) {
        do {
            for (int i = 0; i < clazz.getDeclaredMethods().length; ++i) {
                Method method = clazz.getDeclaredMethods()[i];
                if (!methodName.equals(method.getName())) continue;
                return true;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    public static Method getStaticMethod(Class clazz, String methodName, Class[] args) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, args);
            if ((method.getModifiers() & 8) != 0) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static String addResourcePathToPackagePath(Class clazz, String resourceName) {
        if (!resourceName.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz) + "/" + resourceName;
        }
        return ClassUtils.classPackageAsResourcePath(clazz) + resourceName;
    }

    public static String classPackageAsResourcePath(Class clazz) {
        if (clazz == null || clazz.getPackage() == null) {
            return "";
        }
        return clazz.getPackage().getName().replace('.', '/');
    }
}

