/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Array;
import org.springframework.util.Assert;

public abstract class ObjectUtils {
    public static boolean nullSafeEquals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static String getIdentityHexString(Object o) {
        return Integer.toHexString(System.identityHashCode(o));
    }

    public static boolean isCheckedException(Throwable ex) {
        return ex instanceof Exception && !(ex instanceof RuntimeException);
    }

    public static boolean isCompatibleWithThrowsClause(Throwable ex, Class[] declaredExceptions) {
        if (ex instanceof RuntimeException) {
            return true;
        }
        if (declaredExceptions != null) {
            for (int i = 0; i < declaredExceptions.length; ++i) {
                if (!declaredExceptions[i].isAssignableFrom(ex.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public static Object[] toObjectArray(Object primitiveArray) {
        if (primitiveArray == null) {
            return new Object[0];
        }
        Class<?> clazz = primitiveArray.getClass();
        Assert.isTrue(clazz.isArray(), "The specified parameter is not an array--it must be a primitive array.");
        Assert.isTrue(clazz.getComponentType().isPrimitive(), "The specified parameter is not a primitive array.");
        int length = Array.getLength(primitiveArray);
        if (length == 0) {
            return new Object[0];
        }
        Class<?> wrapperType = Array.get(primitiveArray, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(primitiveArray, i);
        }
        return newArray;
    }
}

