/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.lang.reflect.Field;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class FieldRetrievingFactoryBean
implements FactoryBean,
InitializingBean {
    private Class targetClass;
    private Object targetObject;
    private String targetField;
    private Field fieldObject;

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetField(String targetField) {
        this.targetField = targetField;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public void setStaticField(String staticField) throws ClassNotFoundException {
        int lastDotIndex = staticField.lastIndexOf(46);
        if (lastDotIndex == -1 || lastDotIndex == staticField.length()) {
            throw new IllegalArgumentException("staticField must be a fully qualified class plus method name: e.g. 'example.MyExampleClass.MY_EXAMPLE_FIELD'");
        }
        String className = staticField.substring(0, lastDotIndex);
        String fieldName = staticField.substring(lastDotIndex + 1);
        this.setTargetClass(Class.forName(className, true, Thread.currentThread().getContextClassLoader()));
        this.setTargetField(fieldName);
    }

    public void afterPropertiesSet() throws NoSuchFieldException {
        if (this.targetClass == null && this.targetObject == null) {
            throw new IllegalArgumentException("Either targetClass or targetObject is required");
        }
        if (this.targetField == null) {
            throw new IllegalArgumentException("targetField is required");
        }
        Class<?> targetClass = this.targetObject != null ? this.targetObject.getClass() : this.targetClass;
        this.fieldObject = targetClass.getField(this.targetField);
    }

    public Object getObject() throws IllegalAccessException {
        if (this.targetObject != null) {
            return this.fieldObject.get(this.targetObject);
        }
        return this.fieldObject.get(null);
    }

    public Class getObjectType() {
        return this.fieldObject.getType();
    }

    public boolean isSingleton() {
        return true;
    }
}

