/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.jasperreports;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;

public abstract class JasperReportsUtils {
    public static JRDataSource convertReportData(Object value) throws IllegalArgumentException {
        if (value instanceof JRDataSource) {
            return (JRDataSource)value;
        }
        if (value instanceof Collection) {
            return new JRBeanCollectionDataSource((Collection)value);
        }
        if (value instanceof Object[]) {
            return new JRBeanArrayDataSource((Object[])value);
        }
        throw new IllegalArgumentException("Value [" + value + "] cannot be converted to a JRDataSource");
    }

    public static void render(JRAbstractExporter exporter, JasperPrint print, Writer writer) throws JRException {
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        exporter.setParameter(JRExporterParameter.OUTPUT_WRITER, (Object)writer);
        exporter.exportReport();
    }

    public static void render(JRAbstractExporter exporter, JasperPrint print, OutputStream outputStream) throws JRException {
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
        exporter.exportReport();
    }

    public static void renderAsCsv(JasperReport report, Map parameters, Object reportData, Writer writer) throws JRException {
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, (Map)parameters, (JRDataSource)JasperReportsUtils.convertReportData(reportData));
        JasperReportsUtils.render((JRAbstractExporter)new JRCsvExporter(), print, writer);
    }

    public static void renderAsHtml(JasperReport report, Map parameters, Object reportData, Writer writer) throws JRException {
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, (Map)parameters, (JRDataSource)JasperReportsUtils.convertReportData(reportData));
        JasperReportsUtils.render((JRAbstractExporter)new JRHtmlExporter(), print, writer);
    }

    public static void renderAsPdf(JasperReport report, Map parameters, Object reportData, OutputStream stream) throws JRException {
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, (Map)parameters, (JRDataSource)JasperReportsUtils.convertReportData(reportData));
        JasperReportsUtils.render((JRAbstractExporter)new JRPdfExporter(), print, stream);
    }

    public static void renderAsXls(JasperReport report, Map parameters, Object reportData, OutputStream stream) throws JRException {
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, (Map)parameters, (JRDataSource)JasperReportsUtils.convertReportData(reportData));
        JasperReportsUtils.render((JRAbstractExporter)new JRXlsExporter(), print, stream);
    }
}

