/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.client.HessianRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;

public class HessianClientInterceptor
extends UrlBasedRemoteAccessor
implements MethodInterceptor,
InitializingBean {
    private final HessianProxyFactory proxyFactory = new HessianProxyFactory();
    private Object hessianProxy;

    public void setUsername(String username) {
        this.proxyFactory.setUser(username);
    }

    public void setPassword(String password) {
        this.proxyFactory.setPassword(password);
    }

    public void afterPropertiesSet() throws MalformedURLException {
        if (this.getServiceInterface() == null) {
            throw new IllegalArgumentException("serviceInterface is required");
        }
        if (this.getServiceUrl() == null) {
            throw new IllegalArgumentException("serviceUrl is required");
        }
        this.hessianProxy = this.proxyFactory.create(this.getServiceInterface(), this.getServiceUrl());
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return invocation.getMethod().invoke(this.hessianProxy, invocation.getArguments());
        }
        catch (UndeclaredThrowableException ex) {
            throw new RemoteAccessException("Cannot access Hessian service", ex.getUndeclaredThrowable());
        }
        catch (InvocationTargetException ex) {
            this.logger.debug((Object)("Hessian service [" + this.getServiceUrl() + "] threw exception"), ex.getTargetException());
            if (ex.getTargetException() instanceof HessianRuntimeException) {
                HessianRuntimeException hre = (HessianRuntimeException)ex.getTargetException();
                Object rootCause = hre.getRootCause() != null ? hre.getRootCause() : hre;
                throw new RemoteAccessException("Cannot access Hessian service", (Throwable)rootCause);
            }
            if (ex.getTargetException() instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException utex = (UndeclaredThrowableException)ex.getTargetException();
                throw new RemoteAccessException("Cannot access Hessian service", utex.getUndeclaredThrowable());
            }
            throw ex.getTargetException();
        }
    }
}

