/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BeansDtdResolver
implements EntityResolver {
    private static final String DTD_NAME = "spring-beans";
    private static final String SEARCH_PACKAGE = "org/springframework/beans/factory/xml/";
    protected final Log logger = LogFactory.getLog(this.getClass());

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        this.logger.debug((Object)("Trying to resolve XML entity with public ID [" + publicId + "] and system ID [" + systemId + "]"));
        if (systemId != null && systemId.indexOf(DTD_NAME) > systemId.lastIndexOf("/")) {
            String dtdFile = systemId.substring(systemId.indexOf(DTD_NAME));
            this.logger.debug((Object)("Trying to locate [" + dtdFile + "] under [" + SEARCH_PACKAGE + "]"));
            InputStream is = new ClassPathResource(SEARCH_PACKAGE + dtdFile).getInputStream();
            if (is != null) {
                this.logger.debug((Object)("Found beans DTD [" + systemId + "] in class path"));
                InputSource source = new InputSource(is);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
            this.logger.debug((Object)("Could not resolve beans DTD [" + systemId + "]: not found in class path"));
        }
        return null;
    }
}

