/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Iterator;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;

public class PropertyOverrideConfigurer
extends PropertyResourceConfigurer {
    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.processKey(beanFactory, key, props.getProperty(key));
        }
    }

    protected void processKey(ConfigurableListableBeanFactory factory, String key, String value) throws BeansException {
        int dotIndex = key.indexOf(46);
        if (dotIndex == -1) {
            throw new FatalBeanException("Invalid key [" + key + "]: expected 'beanName.property'");
        }
        String beanName = key.substring(0, dotIndex);
        String beanProperty = key.substring(dotIndex + 1);
        factory.overridePropertyValue(beanName, new PropertyValue(beanProperty, value));
        this.logger.debug((Object)("Property '" + key + "' set to [" + value + "]"));
    }
}

