/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.GeneratorStrategy;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Dispatcher;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import net.sf.cglib.transform.impl.UndeclaredThrowableStrategy;
import org.aopalliance.aop.AspectException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopContext;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.aop.support.AopUtils;

public class Cglib2AopProxy
implements AopProxy,
Serializable {
    private static final int AOP_PROXY = 0;
    private static final int INVOKE_TARGET = 1;
    private static final int NO_OVERRIDE = 2;
    private static final int DISPATCH_TARGET = 3;
    private static final int DISPATCH_ADVISED = 4;
    private static final int INVOKE_EQUALS = 5;
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$aop$framework$Cglib2AopProxy == null ? (class$org$springframework$aop$framework$Cglib2AopProxy = Cglib2AopProxy.class$("org.springframework.aop.framework.Cglib2AopProxy")) : class$org$springframework$aop$framework$Cglib2AopProxy));
    protected final AdvisedSupport advised;
    private Object[] constructorArgs;
    private Class[] constructorArgTypes;
    private final transient AdvisedDispatcher advisedDispatcher = new AdvisedDispatcher();
    private transient int fixedInterceptorOffset;
    private transient Map fixedInterceptorMap;
    static /* synthetic */ Class class$org$springframework$aop$framework$Cglib2AopProxy;
    static /* synthetic */ Class class$java$lang$reflect$UndeclaredThrowableException;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$springframework$aop$framework$Advised;

    protected Cglib2AopProxy(AdvisedSupport config) throws AopConfigException {
        if (config == null) {
            throw new AopConfigException("Cannot create AopProxy with null ProxyConfig");
        }
        if (config.getAdvisors().length == 0 && config.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("Cannot create AopProxy with no advisors and no target source");
        }
        if (config.getTargetSource().getTargetClass() == null) {
            throw new AopConfigException("Either an interface or a target is required for proxy creation");
        }
        this.advised = config;
    }

    protected void setConstructorArguments(Object[] constructorArgs, Class[] constructorArgTypes) {
        if (constructorArgs == null || constructorArgTypes == null) {
            throw new IllegalArgumentException("Both constructorArgs and constructorArgTypes need to be specified");
        }
        if (constructorArgs.length != constructorArgTypes.length) {
            throw new IllegalArgumentException("Number of constructorArgs (" + constructorArgs.length + ") must match number of constructorArgTypes (" + constructorArgTypes.length + ")");
        }
        this.constructorArgs = constructorArgs;
        this.constructorArgTypes = constructorArgTypes;
    }

    public Object getProxy() {
        return this.getProxy(null);
    }

    public Object getProxy(ClassLoader classLoader) {
        if (logger.isDebugEnabled()) {
            Class targetClass = this.advised.getTargetSource().getTargetClass();
            logger.debug((Object)("Creating CGLIB2 proxy" + (targetClass != null ? " for [" + targetClass.getName() + "]" : "")));
        }
        Enhancer enhancer = new Enhancer();
        try {
            Class rootClass = this.advised.getTargetSource().getTargetClass();
            if (AopUtils.isCglibProxyClass(rootClass)) {
                enhancer.setSuperclass(rootClass.getSuperclass());
            } else {
                enhancer.setSuperclass(rootClass);
            }
            enhancer.setCallbackFilter((CallbackFilter)new ProxyCallbackFilter(this.advised));
            enhancer.setStrategy((GeneratorStrategy)new UndeclaredThrowableStrategy(class$java$lang$reflect$UndeclaredThrowableException == null ? (class$java$lang$reflect$UndeclaredThrowableException = Cglib2AopProxy.class$("java.lang.reflect.UndeclaredThrowableException")) : class$java$lang$reflect$UndeclaredThrowableException));
            enhancer.setInterfaces(AopProxyUtils.completeProxiedInterfaces(this.advised));
            Callback[] callbacks = this.getCallbacks(rootClass);
            enhancer.setCallbacks(callbacks);
            Class[] types = new Class[callbacks.length];
            for (int x = 0; x < types.length; ++x) {
                types[x] = callbacks[x].getClass();
            }
            enhancer.setCallbackTypes(types);
            Object proxy = this.constructorArgs != null ? enhancer.create(this.constructorArgTypes, this.constructorArgs) : enhancer.create();
            for (int x = 0; x < callbacks.length; ++x) {
                if (!(callbacks[x] instanceof AbstractInterceptor)) continue;
                ((AbstractInterceptor)callbacks[x]).setConstructed(true);
            }
            return proxy;
        }
        catch (CodeGenerationException ex) {
            throw new AspectException("Couldn't generate CGLIB subclass of class '" + this.advised.getTargetSource().getTargetClass() + "': " + "Common causes of this problem include using a final class or a non-visible class", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new AspectException("Couldn't generate CGLIB subclass of class '" + this.advised.getTargetSource().getTargetClass() + "': " + "Common causes of this problem include using a final class or a non-visible class", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new AspectException("Unexpected AOP exception", (Throwable)ex);
        }
    }

    private Callback[] getCallbacks(Class rootClass) throws Exception {
        Callback[] callbacks;
        boolean exposeProxy = this.advised.isExposeProxy();
        boolean isFrozen = this.advised.isFrozen();
        boolean isStatic = this.advised.getTargetSource().isStatic();
        DynamicAdvisedInterceptor aopInterceptor = new DynamicAdvisedInterceptor();
        AbstractInterceptor targetInterceptor = null;
        targetInterceptor = exposeProxy ? (isStatic ? new StaticUnadvisedExposedInterceptor(this.advised.getTargetSource().getTarget()) : new DynamicUnadvisedExposedInterceptor()) : (isStatic ? new StaticUnadvisedInterceptor(this.advised.getTargetSource().getTarget()) : new DynamicUnadvisedInterceptor());
        Serializable targetDispatcher = isStatic ? new StaticDispatcher(this.advised.getTargetSource().getTarget()) : new SerializableNoOp();
        Callback[] mainCallbacks = new Callback[]{aopInterceptor, targetInterceptor, new SerializableNoOp(), targetDispatcher, this.advisedDispatcher, new EqualsInterceptor(this.advised)};
        if (isStatic && isFrozen) {
            int x;
            Callback[] fixedCallbacks = null;
            Method[] methods = rootClass.getMethods();
            fixedCallbacks = new Callback[methods.length];
            this.fixedInterceptorMap = new HashMap();
            for (x = 0; x < methods.length; ++x) {
                List chain = this.advised.getAdvisorChainFactory().getInterceptorsAndDynamicInterceptionAdvice(this.advised, null, methods[x], rootClass);
                fixedCallbacks[x] = new FixedChainStaticTargetInterceptor(chain, this.advised.getTargetSource().getTarget(), this.advised.getTargetSource().getTargetClass());
                this.fixedInterceptorMap.put(methods[x].toString(), new Integer(x));
            }
            callbacks = new Callback[mainCallbacks.length + fixedCallbacks.length];
            for (x = 0; x < mainCallbacks.length; ++x) {
                callbacks[x] = mainCallbacks[x];
            }
            for (x = 0; x < fixedCallbacks.length; ++x) {
                callbacks[x + mainCallbacks.length] = fixedCallbacks[x];
            }
            this.fixedInterceptorOffset = mainCallbacks.length;
        } else {
            callbacks = mainCallbacks;
        }
        return callbacks;
    }

    private static Object massageReturnTypeIfNecessary(Object proxy, Object target, Object retVal) {
        if (retVal != null && retVal == target) {
            retVal = proxy;
        }
        return retVal;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Cglib2AopProxy otherCglibProxy = null;
        if (!(other instanceof Cglib2AopProxy)) {
            return false;
        }
        otherCglibProxy = (Cglib2AopProxy)other;
        return AopProxyUtils.equalsInProxy(this.advised, otherCglibProxy.advised);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProxyCallbackFilter
    implements CallbackFilter {
        private final AdvisedSupport advised;

        public ProxyCallbackFilter(AdvisedSupport advised) {
            this.advised = advised;
        }

        public int accept(Method method) {
            if (Modifier.isProtected(method.getModifiers())) {
                return 2;
            }
            if (method.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = Cglib2AopProxy.class$("java.lang.Object")) : class$java$lang$Object) && method.getName().equals("finalize")) {
                logger.debug((Object)"Object.finalize () method found - using NO_OVERRIDE");
                return 2;
            }
            if (method.getDeclaringClass() == (class$org$springframework$aop$framework$Advised == null ? (class$org$springframework$aop$framework$Advised = Cglib2AopProxy.class$("org.springframework.aop.framework.Advised")) : class$org$springframework$aop$framework$Advised)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Method " + method + " is declared on Advised - using DISPATCH_ADVISED"));
                }
                return 4;
            }
            if (AopUtils.isEqualsMethod(method)) {
                logger.debug((Object)"Found equals() method - using INVOKE_EQUALS");
                return 5;
            }
            Class targetClass = this.advised.getTargetSource().getTargetClass();
            List chain = this.advised.getAdvisorChainFactory().getInterceptorsAndDynamicInterceptionAdvice(this.advised, null, method, targetClass);
            boolean haveAdvice = !chain.isEmpty();
            boolean exposeProxy = this.advised.isExposeProxy();
            boolean isStatic = this.advised.getTargetSource().isStatic();
            boolean isFrozen = this.advised.isFrozen();
            if (haveAdvice) {
                if (exposeProxy) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Must expose proxy on advised method " + method + " - using AOP_PROXY"));
                    }
                    return 0;
                }
                String key = method.toString();
                if (isStatic && isFrozen && Cglib2AopProxy.this.fixedInterceptorMap.containsKey(key)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Method " + method + " has Advice and optimisations are enabled - " + "using specific FixedChainStaticTargetInterceptor"));
                    }
                    int index = (Integer)Cglib2AopProxy.this.fixedInterceptorMap.get(key);
                    return index + Cglib2AopProxy.this.fixedInterceptorOffset;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unable to apply any optimisations to advised method " + method + " - using AOP_PROXY"));
                }
                return 0;
            }
            if (exposeProxy || !isStatic) {
                return 1;
            }
            Class<?> returnType = method.getReturnType();
            if (targetClass == returnType) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Method " + method + "has return type same as target type (may return this) - using INVOKE_TARGET"));
                }
                return 1;
            }
            if (returnType.isPrimitive() || !returnType.isAssignableFrom(targetClass)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Method " + method + " has return type that ensures this cannot be returned- using DISPATCH_TARGET"));
                }
                return 3;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Method " + method + "has return type that is assignable from the target type (may return this) - " + "using INVOKE_TARGET"));
            }
            return 1;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            ProxyCallbackFilter otherCallbackFilter = null;
            if (!(other instanceof ProxyCallbackFilter)) {
                return false;
            }
            otherCallbackFilter = (ProxyCallbackFilter)other;
            if (this.advised.isFrozen() != otherCallbackFilter.advised.isFrozen()) {
                return false;
            }
            if (this.advised.isExposeProxy() != otherCallbackFilter.advised.isExposeProxy()) {
                return false;
            }
            if (this.advised.getTargetSource().isStatic() != otherCallbackFilter.advised.getTargetSource().isStatic()) {
                return false;
            }
            return AopProxyUtils.equalsProxiedInterfaces(this.advised, otherCallbackFilter.advised) && AopProxyUtils.equalsAdvisors(this.advised, otherCallbackFilter.advised);
        }
    }

    private static class CglibMethodInvocation
    extends ReflectiveMethodInvocation {
        private final MethodProxy methodProxy;

        public CglibMethodInvocation(Object proxy, Object target, Method method, Object[] arguments, Class targetClass, List interceptorsAndDynamicMethodMatchers, MethodProxy methodProxy) {
            super(proxy, target, method, arguments, targetClass, interceptorsAndDynamicMethodMatchers);
            this.methodProxy = methodProxy;
        }

        protected Object invokeJoinpoint() throws Throwable {
            return this.methodProxy.invoke(this.target, this.arguments);
        }
    }

    private class DynamicAdvisedInterceptor
    extends AbstractInterceptor
    implements MethodInterceptor,
    Serializable {
        private DynamicAdvisedInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object object;
            boolean setProxyContext;
            Object oldProxy;
            block10: {
                CglibMethodInvocation invocation = null;
                oldProxy = null;
                setProxyContext = false;
                Class<?> targetClass = null;
                Object target = null;
                try {
                    List chain;
                    Object retVal = null;
                    target = this.getTarget();
                    if (target != null) {
                        targetClass = target.getClass();
                    }
                    if (Cglib2AopProxy.this.advised.exposeProxy) {
                        oldProxy = AopContext.setCurrentProxy(proxy);
                        setProxyContext = true;
                    }
                    if ((chain = Cglib2AopProxy.this.advised.getAdvisorChainFactory().getInterceptorsAndDynamicInterceptionAdvice(Cglib2AopProxy.this.advised, proxy, method, targetClass)).isEmpty()) {
                        retVal = methodProxy.invoke(target, args);
                    } else if (this.constructed) {
                        invocation = new CglibMethodInvocation(proxy, target, method, args, targetClass, chain, methodProxy);
                        retVal = invocation.proceed();
                    } else {
                        retVal = methodProxy.invokeSuper(proxy, args);
                    }
                    object = retVal = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, retVal);
                    Object var14_13 = null;
                    if (target == null) break block10;
                }
                catch (Throwable throwable) {
                    block11: {
                        Object var14_14 = null;
                        if (target != null) {
                            this.releaseTarget(target);
                        }
                        if (!setProxyContext) break block11;
                        AopContext.setCurrentProxy(oldProxy);
                    }
                    throw throwable;
                }
                this.releaseTarget(target);
            }
            if (setProxyContext) {
                AopContext.setCurrentProxy(oldProxy);
            }
            return object;
        }

        public int hashCode() {
            return Cglib2AopProxy.this.advised.hashCode();
        }

        protected Object getTarget() throws Exception {
            return Cglib2AopProxy.this.advised.getTargetSource().getTarget();
        }

        protected void releaseTarget(Object target) throws Exception {
            Cglib2AopProxy.this.advised.getTargetSource().releaseTarget(target);
        }
    }

    private static class FixedChainStaticTargetInterceptor
    extends AbstractInterceptor
    implements MethodInterceptor,
    Serializable {
        private final List adviceChain;
        private final Object target;
        private final Class targetClass;

        public FixedChainStaticTargetInterceptor(List adviceChain, Object target, Class targetClass) {
            this.adviceChain = adviceChain;
            this.target = target;
            this.targetClass = targetClass;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object retVal = null;
            if (this.constructed) {
                CglibMethodInvocation invocation = null;
                invocation = new CglibMethodInvocation(proxy, this.target, method, args, this.targetClass, this.adviceChain, methodProxy);
                retVal = invocation.proceed();
            } else {
                retVal = methodProxy.invokeSuper(proxy, args);
            }
            retVal = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, retVal);
            return retVal;
        }
    }

    private static class EqualsInterceptor
    implements MethodInterceptor,
    Serializable {
        private final AdvisedSupport advised;

        public EqualsInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Callback callback;
            Object other = args[0];
            if (other == null) {
                return Boolean.FALSE;
            }
            if (other == proxy) {
                return Boolean.TRUE;
            }
            AdvisedSupport otherAdvised = null;
            if (other instanceof Factory) {
                callback = ((Factory)other).getCallback(5);
                if (!(callback instanceof EqualsInterceptor)) {
                    return Boolean.FALSE;
                }
            } else {
                return Boolean.FALSE;
            }
            otherAdvised = ((EqualsInterceptor)callback).advised;
            return new Boolean(AopProxyUtils.equalsInProxy(this.advised, otherAdvised));
        }
    }

    private class AdvisedDispatcher
    implements Dispatcher,
    Serializable {
        private AdvisedDispatcher() {
        }

        public Object loadObject() throws Exception {
            return Cglib2AopProxy.this.advised;
        }
    }

    private static class StaticDispatcher
    implements Dispatcher,
    Serializable {
        private Object target;

        public StaticDispatcher(Object target) {
            this.target = target;
        }

        public Object loadObject() {
            return this.target;
        }
    }

    private class DynamicUnadvisedExposedInterceptor
    extends AbstractInterceptor
    implements MethodInterceptor,
    Serializable {
        private DynamicUnadvisedExposedInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object object;
            Object oldProxy = null;
            Object target = Cglib2AopProxy.this.advised.getTargetSource().getTarget();
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object retVal = this.doInvoke(methodProxy, target, proxy, args);
                object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, retVal);
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                AopContext.setCurrentProxy(oldProxy);
                Cglib2AopProxy.this.advised.getTargetSource().releaseTarget(target);
                throw throwable;
            }
            AopContext.setCurrentProxy(oldProxy);
            Cglib2AopProxy.this.advised.getTargetSource().releaseTarget(target);
            return object;
        }
    }

    private class DynamicUnadvisedInterceptor
    extends AbstractInterceptor
    implements MethodInterceptor,
    Serializable {
        private DynamicUnadvisedInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object target = Cglib2AopProxy.this.advised.getTargetSource().getTarget();
            try {
                Object retVal = this.doInvoke(methodProxy, target, proxy, args);
                Object object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, retVal);
                return object;
            }
            finally {
                Cglib2AopProxy.this.advised.getTargetSource().releaseTarget(target);
            }
        }
    }

    private static class StaticUnadvisedExposedInterceptor
    extends AbstractInterceptor
    implements MethodInterceptor,
    Serializable {
        private final Object target;

        public StaticUnadvisedExposedInterceptor(Object target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object retVal = this.doInvoke(methodProxy, this.target, proxy, args);
                Object object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, retVal);
                return object;
            }
            finally {
                AopContext.setCurrentProxy(oldProxy);
            }
        }
    }

    private static class StaticUnadvisedInterceptor
    extends AbstractInterceptor
    implements MethodInterceptor,
    Serializable {
        private final Object target;

        public StaticUnadvisedInterceptor(Object target) {
            this.target = target;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object retVal = this.doInvoke(methodProxy, this.target, proxy, args);
            return Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, retVal);
        }
    }

    private static abstract class AbstractInterceptor
    implements Serializable {
        protected boolean constructed = false;

        private AbstractInterceptor() {
        }

        public void setConstructed(boolean constructed) {
            this.constructed = constructed;
        }

        protected Object doInvoke(MethodProxy methodProxy, Object target, Object proxy, Object[] args) throws Throwable {
            if (this.constructed) {
                return methodProxy.invoke(target, args);
            }
            return methodProxy.invokeSuper(proxy, args);
        }
    }

    public static class SerializableNoOp
    implements NoOp,
    Serializable {
    }
}

