/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConcurrencyThrottleInterceptor
implements MethodInterceptor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int concurrencyLimit = 1;
    private int concurrencyCount = 0;

    public void setConcurrencyLimit(int concurrencyLimit) {
        this.concurrencyLimit = concurrencyLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        ConcurrencyThrottleInterceptor concurrencyThrottleInterceptor;
        boolean debug = this.logger.isDebugEnabled();
        Object object = this;
        synchronized (object) {
            while (this.concurrencyCount >= this.concurrencyLimit) {
                if (debug) {
                    this.logger.debug((Object)("Concurrency count " + this.concurrencyCount + " has reached limit " + this.concurrencyLimit + " - blocking"));
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (debug) {
                this.logger.debug((Object)("Entering method at concurrency count " + this.concurrencyCount));
            }
            ++this.concurrencyCount;
        }
        try {
            object = methodInvocation.proceed();
            Object var7_6 = null;
            concurrencyThrottleInterceptor = this;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ConcurrencyThrottleInterceptor concurrencyThrottleInterceptor2 = this;
            synchronized (concurrencyThrottleInterceptor2) {
                --this.concurrencyCount;
                if (debug) {
                    this.logger.debug((Object)("Returning from method at concurrency count " + this.concurrencyCount));
                }
                this.notify();
            }
            throw throwable;
        }
        synchronized (concurrencyThrottleInterceptor) {
            --this.concurrencyCount;
            if (debug) {
                this.logger.debug((Object)("Returning from method at concurrency count " + this.concurrencyCount));
            }
            this.notify();
        }
        return object;
    }
}

