/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.AdvisorChainFactoryUtils;

public final class HashMapCachingAdvisorChainFactory
implements AdvisorChainFactory {
    private Map methodCache = this.createMap();

    private Map createMap() {
        try {
            Class<?> clazz = Class.forName("java.util.IdentityHashMap");
            return (Map)clazz.newInstance();
        }
        catch (Exception ex) {
            LogFactory.getLog(this.getClass()).debug((Object)"Falling back to HashMap (JDK 1.3?): couldn't create an IdentityHashMap using reflection", (Throwable)ex);
            return new HashMap();
        }
    }

    public List getInterceptorsAndDynamicInterceptionAdvice(Advised config, Object proxy, Method method, Class targetClass) {
        List cached = (List)this.methodCache.get(method);
        if (cached == null) {
            cached = AdvisorChainFactoryUtils.calculateInterceptorsAndDynamicInterceptionAdvice(config, proxy, method, targetClass);
            this.methodCache.put(method, cached);
        }
        return cached;
    }

    public void activated(AdvisedSupport advisedSupport) {
    }

    public void adviceChanged(AdvisedSupport advisedSupport) {
        this.methodCache.clear();
    }
}

