/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.aop.framework.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.ControlFlow;
import org.springframework.core.ControlFlowFactory;
import org.springframework.core.OrderComparator;

public abstract class AbstractAdvisorAutoProxyCreator
extends AbstractAutoProxyCreator {
    protected abstract List findCandidateAdvisors();

    protected List findEligibleAdvisors(Class clazz) {
        List candidateAdvice = this.findCandidateAdvisors();
        LinkedList<Advisor> eligibleAdvice = new LinkedList<Advisor>();
        for (int i = 0; i < candidateAdvice.size(); ++i) {
            Advisor candidate = (Advisor)candidateAdvice.get(i);
            if (AopUtils.canApply(candidate, clazz, null)) {
                eligibleAdvice.add(candidate);
                this.logger.info((Object)("Candidate Advice [" + candidate + "] ACCEPTED for class '" + clazz.getName() + "'"));
                continue;
            }
            this.logger.info((Object)("Candidate Advice [" + candidate + "] REJECTED for class '" + clazz.getName() + "'"));
        }
        return eligibleAdvice;
    }

    protected Object[] getInterceptorsAndAdvisorsForBean(Object bean, String name) {
        List advices = this.findEligibleAdvisors(bean.getClass());
        if (advices.isEmpty()) {
            return this.DO_NOT_PROXY;
        }
        advices = this.sortAdvisors(advices);
        return advices.toArray();
    }

    protected List sortAdvisors(List l) {
        Collections.sort(l, new OrderComparator());
        return l;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this.findCandidateAdvisors();
    }

    protected boolean shouldSkip(Object bean, String name) {
        ControlFlow cflow = ControlFlowFactory.createControlFlow();
        return cflow.under(this.getClass(), "findCandidateAdvisors");
    }
}

