/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.jndikit.rmi;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.rmi.MarshalledObject;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.InitialContextFactory;
import org.codehaus.spice.jndikit.DefaultNamespace;
import org.codehaus.spice.jndikit.Namespace;
import org.codehaus.spice.jndikit.NamingProvider;
import org.codehaus.spice.jndikit.RemoteContext;

public class RMIInitialContextFactory
implements InitialContextFactory {
    public Context getInitialContext(Hashtable environment) throws NamingException {
        NamingProvider provider = this.newNamingProvider(environment);
        environment.put("org.codehaus.spice.jndikit.NamingProvider", provider);
        Namespace namespace = this.newNamespace(environment);
        environment.put("org.codehaus.spice.jndikit.Namespace", namespace);
        Name baseName = namespace.getNameParser().parse("");
        return new RemoteContext(environment, baseName);
    }

    protected NamingProvider newNamingProvider(Hashtable environment) throws NamingException {
        int index;
        String url = (String)environment.get("java.naming.provider.url");
        if (null == url) {
            return this.newNamingProvider("localhost", 1977);
        }
        if (!url.startsWith("rmi://")) {
            throw new ConfigurationException("Malformed url - " + url);
        }
        int end = index = url.indexOf(58, 6);
        int port = 1977;
        if (-1 == index) {
            end = url.length();
        } else {
            port = Integer.parseInt(url.substring(index + 1));
        }
        String host = url.substring(6, end);
        return this.newNamingProvider(host, port);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NamingProvider newNamingProvider(String host, int port) throws NamingException {
        NamingProvider namingProvider;
        Socket socket = null;
        try {
            try {
                socket = new Socket(host, port);
                BufferedInputStream buffered = new BufferedInputStream(socket.getInputStream());
                ObjectInputStream input = new ObjectInputStream(buffered);
                MarshalledObject object = (MarshalledObject)input.readObject();
                NamingProvider provider = (NamingProvider)object.get();
                socket.close();
                socket = null;
                namingProvider = provider;
                Object var10_11 = null;
                if (null == socket) return namingProvider;
            }
            catch (Exception e) {
                ServiceUnavailableException sue = new ServiceUnavailableException(e.getMessage());
                sue.setRootCause(e);
                throw sue;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (null == socket) throw throwable;
            try {
                socket.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe) {
            // empty catch block
            return namingProvider;
        }
        socket.close();
        return namingProvider;
    }

    protected Namespace newNamespace(Hashtable environment) throws NamingException {
        try {
            NamingProvider provider = (NamingProvider)environment.get("org.codehaus.spice.jndikit.NamingProvider");
            return new DefaultNamespace(provider.getNameParser());
        }
        catch (Exception e) {
            if (e instanceof NamingException) {
                throw (NamingException)e;
            }
            ServiceUnavailableException sue = new ServiceUnavailableException(e.getMessage());
            sue.setRootCause(e);
            throw sue;
        }
    }
}

