/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.jndikit;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.StateFactory;
import org.codehaus.spice.jndikit.Namespace;

public abstract class AbstractNamespace
implements Namespace {
    protected ObjectFactory[] m_objectFactorySet;
    protected StateFactory[] m_stateFactorySet;

    public Object getStateToBind(Object object, Name name, Context parent, Hashtable environment) throws NamingException {
        StateFactory[] stateFactorySet = this.m_stateFactorySet;
        int i = 0;
        while (i < stateFactorySet.length) {
            Object result = stateFactorySet[i].getStateToBind(object, name, parent, environment);
            if (null != result) {
                return result;
            }
            ++i;
        }
        return object;
    }

    public Object getObjectInstance(Object object, Name name, Context parent, Hashtable environment) throws Exception {
        ObjectFactory[] objectFactorySet = this.m_objectFactorySet;
        int i = 0;
        while (i < objectFactorySet.length) {
            Object result = objectFactorySet[i].getObjectInstance(object, name, parent, environment);
            if (null != result) {
                return result;
            }
            ++i;
        }
        return object;
    }

    protected synchronized void addStateFactory(StateFactory stateFactory) {
        StateFactory[] stateFactorySet = new StateFactory[this.m_stateFactorySet.length + 1];
        System.arraycopy(this.m_stateFactorySet, 0, stateFactorySet, 0, this.m_stateFactorySet.length);
        stateFactorySet[this.m_stateFactorySet.length] = stateFactory;
        this.m_stateFactorySet = stateFactorySet;
    }

    protected synchronized void addObjectFactory(ObjectFactory objectFactory) {
        ObjectFactory[] objectFactorySet = new ObjectFactory[this.m_objectFactorySet.length + 1];
        System.arraycopy(this.m_objectFactorySet, 0, objectFactorySet, 0, this.m_objectFactorySet.length);
        objectFactorySet[this.m_objectFactorySet.length] = objectFactory;
        this.m_objectFactorySet = objectFactorySet;
    }
}

