/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.jndikit;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public abstract class AbstractContext
implements Context {
    private Hashtable m_environment;

    public AbstractContext() {
        this(new Hashtable());
    }

    public AbstractContext(Hashtable environment) {
        this.m_environment = environment;
    }

    protected abstract NameParser getNameParser() throws NamingException;

    public Object addToEnvironment(String key, Object value) throws NamingException {
        if (null == this.m_environment) {
            this.m_environment = new Hashtable(5, 0.75f);
        }
        return this.m_environment.put(key, value);
    }

    public void close() {
        this.m_environment = null;
    }

    protected boolean isSelf(Name name) {
        return name.isEmpty() || name.get(0).equals("");
    }

    public void bind(String name, Object object) throws NamingException {
        this.bind(this.getNameParser().parse(name), object);
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name, object, false);
    }

    protected abstract void bind(Name var1, Object var2, boolean var3) throws NamingException;

    public String composeName(String name, String prefix) throws NamingException {
        NameParser nameParser = this.getNameParser();
        Name result = this.composeName(nameParser.parse(name), nameParser.parse(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.getNameParser().parse(name));
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.getNameParser().parse(name));
    }

    public Hashtable getEnvironment() throws NamingException {
        if (null == this.m_environment) {
            return new Hashtable(3, 0.75f);
        }
        return (Hashtable)this.m_environment.clone();
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(this.getNameParser().parse(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.getNameParser();
        }
        Object object = this.lookup(name);
        if (!(object instanceof Context)) {
            object = this.lookup(this.getPathName(name));
        }
        Context context = (Context)object;
        NameParser parser = context.getNameParser("");
        context.close();
        return parser;
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(this.getNameParser().parse(name));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(this.getNameParser().parse(name));
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(this.getNameParser().parse(name));
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this.getNameParser().parse(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void rebind(String name, Object object) throws NamingException {
        this.rebind(this.getNameParser().parse(name), object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.bind(name, object, true);
    }

    public Object removeFromEnvironment(String key) throws NamingException {
        if (null == this.m_environment) {
            return null;
        }
        return this.m_environment.remove(key);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(this.getNameParser().parse(oldName), this.getNameParser().parse(newName));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (this.isSelf(oldName) || this.isSelf(newName)) {
            String message = "Failed to rebind self";
            throw new InvalidNameException("Failed to rebind self");
        }
        if (oldName.equals(newName)) {
            String message = "Failed to rebind identical names";
            throw new InvalidNameException("Failed to rebind identical names");
        }
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    public void unbind(String name) throws NamingException {
        this.unbind(this.getNameParser().parse(name));
    }

    protected final Hashtable getRawEnvironment() {
        return this.m_environment;
    }

    protected Name getPathName(Name name) throws NamingException {
        return name.getPrefix(name.size() - 1);
    }

    protected Name getLeafName(Name name) throws NamingException {
        return name.getSuffix(name.size() - 1);
    }
}

