/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.flare.fastutil;

import it.unimi.dsi.fastutil.longs.AbstractLong2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import space.vectrix.flare.fastutil.Long2ObjectSyncMap;

final class Long2ObjectSyncMapImpl<V>
extends AbstractLong2ObjectMap<V>
implements Long2ObjectSyncMap<V> {
    private static final long serialVersionUID = 1L;
    private final Object lock = new Object();
    private final IntFunction<Long2ObjectMap<Long2ObjectSyncMap.ExpungingValue<V>>> function;
    private volatile Long2ObjectMap<Long2ObjectSyncMap.ExpungingValue<V>> read;
    private volatile boolean readAmended;
    private int readMisses;
    private Long2ObjectMap<Long2ObjectSyncMap.ExpungingValue<V>> dirty;
    private EntrySet entrySet;

    Long2ObjectSyncMapImpl(@NonNull IntFunction<Long2ObjectMap<Long2ObjectSyncMap.ExpungingValue<V>>> function, int initialCapacity) {
        this.function = function;
        this.read = function.apply(initialCapacity);
    }

    @Override
    public int size() {
        this.promoteIfNeeded();
        int size = 0;
        for (Long2ObjectSyncMap.ExpungingValue value : this.read.values()) {
            if (!value.exists()) continue;
            ++size;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(long key) {
        Long2ObjectSyncMap.ExpungingValue entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Long2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    this.missLocked();
                }
            }
        }
        return entry != null && entry.exists();
    }

    public boolean containsValue(@Nullable Object value) {
        ObjectIterator iterator = this.long2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            if (!Objects.equals(((Map.Entry)iterator.next()).getValue(), value)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long key) {
        Long2ObjectSyncMap.ExpungingValue entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Long2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    this.missLocked();
                }
            }
        }
        return entry != null ? (V)entry.get() : null;
    }

    public V put(long key, @NonNull V value) {
        V previous;
        Objects.requireNonNull(value, "value");
        Long2ObjectSyncMap.ExpungingValue entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
        V v = previous = entry != null ? (V)entry.get() : null;
        if (entry != null && entry.trySet(value)) {
            return previous;
        }
        return this.putDirty(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putDirty(long key, @NonNull V value, boolean present) {
        V previous = null;
        Object object = this.lock;
        synchronized (object) {
            Long2ObjectSyncMap.ExpungingValue entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
            if (entry != null) {
                previous = entry.get();
                if (entry.tryUnexpungeAndSet(value)) {
                    this.dirty.put(key, (Object)entry);
                } else {
                    entry.set(value);
                }
            } else {
                Long2ObjectSyncMap.ExpungingValue expungingValue = entry = this.dirty != null ? (Long2ObjectSyncMap.ExpungingValue)this.dirty.get(key) : null;
                if (entry != null) {
                    previous = entry.get();
                    entry.set(value);
                    this.missLocked();
                } else if (!present) {
                    if (!this.readAmended) {
                        this.dirtyLocked();
                        this.readAmended = true;
                    }
                    if (this.dirty != null && (entry = (Long2ObjectSyncMap.ExpungingValue)this.dirty.put(key, new ExpungingValueImpl(value))) != null) {
                        previous = entry.get();
                    }
                }
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(long key) {
        Long2ObjectSyncMap.ExpungingValue entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Long2ObjectSyncMap.ExpungingValue)this.dirty.remove(key);
                    this.missLocked();
                }
            }
        }
        return entry != null ? (V)entry.clear() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(long key, @NonNull Object value) {
        Objects.requireNonNull(value, "value");
        Long2ObjectSyncMap.ExpungingValue entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Long2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    entry = entry != null && entry.replace(value, null) ? (Long2ObjectSyncMap.ExpungingValue)this.dirty.remove(key) : null;
                    this.missLocked();
                    return entry != null;
                }
            }
        }
        return entry != null && entry.replace(value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(long key, @NonNull V value) {
        Objects.requireNonNull(value, "value");
        Long2ObjectSyncMap.ExpungingValue entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
        Map.Entry<Boolean, V> result = null;
        if (entry != null && (result = entry.putIfAbsent(value)).getKey() == Boolean.TRUE) {
            return result.getValue();
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
            if (entry != null) {
                if (entry.tryUnexpungeAndSet(value)) {
                    this.dirty.put(key, (Object)entry);
                }
            } else {
                Long2ObjectSyncMap.ExpungingValue expungingValue = entry = this.dirty != null ? (Long2ObjectSyncMap.ExpungingValue)this.dirty.get(key) : null;
                if (entry != null) {
                    result = entry.putIfAbsent(value);
                    this.missLocked();
                } else {
                    if (!this.readAmended) {
                        this.dirtyLocked();
                        this.readAmended = true;
                    }
                    if (this.dirty != null) {
                        this.dirty.put(key, new ExpungingValueImpl(value));
                    }
                }
            }
        }
        return result != null ? (V)result.getValue() : null;
    }

    public V replace(long key, @NonNull V value) {
        V previous;
        Objects.requireNonNull(value, "value");
        Long2ObjectSyncMap.ExpungingValue entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
        V v = previous = entry != null ? (V)entry.get() : null;
        if (entry != null && entry.trySet(value) || !this.readAmended) {
            return previous;
        }
        return this.putDirty(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(long key, @NonNull V oldValue, @NonNull V newValue) {
        Objects.requireNonNull(oldValue, "oldValue");
        Objects.requireNonNull(newValue, "newValue");
        Long2ObjectSyncMap.ExpungingValue entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Long2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Long2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    if (entry != null && !entry.replace(oldValue, newValue)) {
                        entry = null;
                    }
                    this.missLocked();
                    return entry != null;
                }
            }
        }
        return entry != null && entry.replace(oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.read = this.function.apply(this.read.size());
            this.readAmended = false;
            this.dirty = null;
            this.readMisses = 0;
        }
    }

    @Override
    public @NonNull ObjectSet<// Could not load outer class - annotation placement on inner may be incorrect
    Long2ObjectMap.Entry<V>> long2ObjectEntrySet() {
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promoteIfNeeded() {
        if (this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                if (this.readAmended) {
                    this.promoteLocked();
                }
            }
        }
    }

    private void promoteLocked() {
        if (this.dirty != null) {
            this.read = this.dirty;
        }
        this.readAmended = false;
        this.dirty = null;
        this.readMisses = 0;
    }

    private void missLocked() {
        if (++this.readMisses > (this.dirty != null ? this.dirty.size() : 0)) {
            this.promoteLocked();
        }
    }

    private void dirtyLocked() {
        if (this.dirty != null) {
            return;
        }
        this.dirty = this.function.apply(this.read.size());
        Long2ObjectMaps.fastForEach(this.read, entry -> {
            if (!((Long2ObjectSyncMap.ExpungingValue)entry.getValue()).tryMarkExpunged()) {
                this.dirty.put(entry.getLongKey(), (Object)((Long2ObjectSyncMap.ExpungingValue)entry.getValue()));
            }
        });
    }

    private final class EntryIterator
    implements ObjectIterator<Long2ObjectMap.Entry<V>> {
        private final Iterator<Long2ObjectMap.Entry<Long2ObjectSyncMap.ExpungingValue<V>>> backingIterator;
        private Long2ObjectMap.Entry<V> next;
        private Long2ObjectMap.Entry<V> current;

        private EntryIterator(Iterator<Long2ObjectMap.Entry<Long2ObjectSyncMap.ExpungingValue<V>>> backingIterator) {
            this.backingIterator = backingIterator;
            Long2ObjectMap.Entry entry = this.getNextValue();
            this.next = entry != null ? new MapEntry(entry) : null;
        }

        private Long2ObjectMap.Entry<Long2ObjectSyncMap.ExpungingValue<V>> getNextValue() {
            Long2ObjectMap.Entry entry = null;
            while (this.backingIterator.hasNext() && entry == null) {
                entry = this.backingIterator.next();
                Long2ObjectSyncMap.ExpungingValue value = (Long2ObjectSyncMap.ExpungingValue)entry.getValue();
                if (value.exists()) continue;
                entry = null;
            }
            return entry;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Long2ObjectMap.Entry<V> next() {
            this.current = this.next;
            Long2ObjectMap.Entry entry = this.getNextValue();
            MapEntry mapEntry = this.next = entry != null ? new MapEntry(entry) : null;
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        public void remove() {
            if (this.current == null) {
                return;
            }
            Long2ObjectSyncMapImpl.this.remove(this.current.getLongKey());
        }

        public void forEachRemaining(@NonNull Consumer<? super // Could not load outer class - annotation placement on inner may be incorrect
        Long2ObjectMap.Entry<V>> action) {
            if (this.next != null) {
                action.accept(this.next);
            }
            this.backingIterator.forEachRemaining((? super E entry) -> {
                if (((Long2ObjectSyncMap.ExpungingValue)entry.getValue()).exists()) {
                    action.accept(new MapEntry((Long2ObjectMap.Entry)entry));
                }
            });
        }
    }

    private final class EntrySet
    extends AbstractObjectSet<Long2ObjectMap.Entry<V>> {
        private EntrySet() {
        }

        public int size() {
            return Long2ObjectSyncMapImpl.this.size();
        }

        public boolean contains(@Nullable Object entry) {
            if (!(entry instanceof Long2ObjectMap.Entry)) {
                return false;
            }
            Long2ObjectMap.Entry mapEntry = (Long2ObjectMap.Entry)entry;
            Object value = Long2ObjectSyncMapImpl.this.get(mapEntry.getLongKey());
            return value != null && Objects.equals(value, mapEntry.getValue());
        }

        public boolean remove(@Nullable Object entry) {
            if (!(entry instanceof Long2ObjectMap.Entry)) {
                return false;
            }
            Long2ObjectMap.Entry mapEntry = (Long2ObjectMap.Entry)entry;
            return Long2ObjectSyncMapImpl.this.remove(mapEntry.getLongKey()) != null;
        }

        public void clear() {
            Long2ObjectSyncMapImpl.this.clear();
        }

        public @NonNull ObjectIterator<// Could not load outer class - annotation placement on inner may be incorrect
        Long2ObjectMap.Entry<V>> iterator() {
            Long2ObjectSyncMapImpl.this.promoteIfNeeded();
            return new EntryIterator((Iterator)Long2ObjectSyncMapImpl.this.read.long2ObjectEntrySet().iterator());
        }
    }

    private final class MapEntry
    implements Long2ObjectMap.Entry<V> {
        private final long key;

        private MapEntry(Long2ObjectMap.Entry<Long2ObjectSyncMap.ExpungingValue<V>> entry) {
            this.key = entry.getLongKey();
        }

        public long getLongKey() {
            return this.key;
        }

        public @Nullable V getValue() {
            return Long2ObjectSyncMapImpl.this.get(this.key);
        }

        public @Nullable V setValue(@NonNull V value) {
            return Long2ObjectSyncMapImpl.this.put(this.key, value);
        }

        public @NonNull String toString() {
            return "Long2ObjectSyncMapImpl.MapEntry{key=" + this.getLongKey() + ", value=" + this.getValue() + "}";
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Long2ObjectMap.Entry)) {
                return false;
            }
            Long2ObjectMap.Entry that = (Long2ObjectMap.Entry)other;
            return Objects.equals(this.getLongKey(), that.getLongKey()) && Objects.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getLongKey(), this.getValue());
        }
    }

    private static final class ExpungingValueImpl<V>
    implements Long2ObjectSyncMap.ExpungingValue<V> {
        private static final AtomicReferenceFieldUpdater<ExpungingValueImpl, Object> VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ExpungingValueImpl.class, Object.class, "value");
        private static final Object EXPUNGED = new Object();
        private volatile Object value;

        private ExpungingValueImpl(@NonNull V value) {
            this.value = value;
        }

        @Override
        public @Nullable V get() {
            Object value = VALUE_UPDATER.get(this);
            return (V)(value == EXPUNGED ? null : value);
        }

        @Override
        public  @NonNull Map.Entry<Boolean, V> putIfAbsent(@NonNull V value) {
            do {
                Object previous;
                if ((previous = VALUE_UPDATER.get(this)) == EXPUNGED) {
                    return new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.FALSE, null);
                }
                if (previous == null) continue;
                return new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.TRUE, previous);
            } while (!VALUE_UPDATER.compareAndSet(this, null, value));
            return new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.TRUE, null);
        }

        @Override
        public boolean expunged() {
            return VALUE_UPDATER.get(this) == EXPUNGED;
        }

        @Override
        public boolean exists() {
            Object value = VALUE_UPDATER.get(this);
            return value != null && value != EXPUNGED;
        }

        @Override
        public void set(@NonNull V value) {
            VALUE_UPDATER.set(this, value);
        }

        @Override
        public boolean replace(@NonNull Object compare, @Nullable V newValue) {
            Object value;
            do {
                if ((value = VALUE_UPDATER.get(this)) != EXPUNGED && Objects.equals(value, compare)) continue;
                return false;
            } while (!VALUE_UPDATER.compareAndSet(this, value, newValue));
            return true;
        }

        @Override
        public @Nullable V clear() {
            Object value;
            do {
                if ((value = VALUE_UPDATER.get(this)) != null && value != EXPUNGED) continue;
                return null;
            } while (!VALUE_UPDATER.compareAndSet(this, value, null));
            return (V)value;
        }

        @Override
        public boolean trySet(@NonNull V value) {
            Object present;
            do {
                if ((present = VALUE_UPDATER.get(this)) != EXPUNGED) continue;
                return false;
            } while (!VALUE_UPDATER.compareAndSet(this, present, value));
            return true;
        }

        @Override
        public boolean tryMarkExpunged() {
            Object value = VALUE_UPDATER.get(this);
            while (value == null) {
                if (VALUE_UPDATER.compareAndSet(this, null, EXPUNGED)) {
                    return true;
                }
                value = VALUE_UPDATER.get(this);
            }
            return false;
        }

        @Override
        public boolean tryUnexpungeAndSet(@Nullable V value) {
            return VALUE_UPDATER.compareAndSet(this, EXPUNGED, value);
        }

        public String toString() {
            return "Long2ObjectSyncMapImpl.ExpungingValue{value=" + this.get() + "}";
        }
    }
}

