/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.flare.fastutil;

import it.unimi.dsi.fastutil.floats.AbstractFloat2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectMaps;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import space.vectrix.flare.fastutil.Float2ObjectSyncMap;

final class Float2ObjectSyncMapImpl<V>
extends AbstractFloat2ObjectMap<V>
implements Float2ObjectSyncMap<V> {
    private static final long serialVersionUID = 1L;
    private final Object lock = new Object();
    private final IntFunction<Float2ObjectMap<Float2ObjectSyncMap.ExpungingValue<V>>> function;
    private volatile Float2ObjectMap<Float2ObjectSyncMap.ExpungingValue<V>> read;
    private volatile boolean readAmended;
    private int readMisses;
    private Float2ObjectMap<Float2ObjectSyncMap.ExpungingValue<V>> dirty;
    private EntrySet entrySet;

    Float2ObjectSyncMapImpl(@NonNull IntFunction<Float2ObjectMap<Float2ObjectSyncMap.ExpungingValue<V>>> function, int initialCapacity) {
        this.function = function;
        this.read = function.apply(initialCapacity);
    }

    @Override
    public int size() {
        this.promoteIfNeeded();
        int size = 0;
        for (Float2ObjectSyncMap.ExpungingValue value : this.read.values()) {
            if (!value.exists()) continue;
            ++size;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(float key) {
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    this.missLocked();
                }
            }
        }
        return entry != null && entry.exists();
    }

    public boolean containsValue(@Nullable Object value) {
        ObjectIterator iterator = this.float2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            if (!Objects.equals(((Map.Entry)iterator.next()).getValue(), value)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(float key) {
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    this.missLocked();
                }
            }
        }
        return entry != null ? (V)entry.get() : null;
    }

    public V put(float key, @NonNull V value) {
        V previous;
        Objects.requireNonNull(value, "value");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        V v = previous = entry != null ? (V)entry.get() : null;
        if (entry != null && entry.trySet(value)) {
            return previous;
        }
        return this.putDirty(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putDirty(float key, @NonNull V value, boolean present) {
        V previous = null;
        Object object = this.lock;
        synchronized (object) {
            Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
            if (entry != null) {
                previous = entry.get();
                if (entry.tryUnexpungeAndSet(value)) {
                    this.dirty.put(key, (Object)entry);
                } else {
                    entry.set(value);
                }
            } else {
                Float2ObjectSyncMap.ExpungingValue expungingValue = entry = this.dirty != null ? (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key) : null;
                if (entry != null) {
                    previous = entry.get();
                    entry.set(value);
                    this.missLocked();
                } else if (!present) {
                    if (!this.readAmended) {
                        this.dirtyLocked();
                        this.readAmended = true;
                    }
                    if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.put(key, new ExpungingValueImpl(value))) != null) {
                        previous = entry.get();
                    }
                }
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(float key) {
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.remove(key);
                    this.missLocked();
                }
            }
        }
        return entry != null ? (V)entry.clear() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(float key, @NonNull Object value) {
        Objects.requireNonNull(value, "value");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    entry = entry != null && entry.replace(value, null) ? (Float2ObjectSyncMap.ExpungingValue)this.dirty.remove(key) : null;
                    this.missLocked();
                    return entry != null;
                }
            }
        }
        return entry != null && entry.replace(value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(float key, @NonNull V value) {
        Objects.requireNonNull(value, "value");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        Map.Entry<Boolean, V> result = null;
        if (entry != null && (result = entry.putIfAbsent(value)).getKey() == Boolean.TRUE) {
            return result.getValue();
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
            if (entry != null) {
                if (entry.tryUnexpungeAndSet(value)) {
                    this.dirty.put(key, (Object)entry);
                }
            } else {
                Float2ObjectSyncMap.ExpungingValue expungingValue = entry = this.dirty != null ? (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key) : null;
                if (entry != null) {
                    result = entry.putIfAbsent(value);
                    this.missLocked();
                } else {
                    if (!this.readAmended) {
                        this.dirtyLocked();
                        this.readAmended = true;
                    }
                    if (this.dirty != null) {
                        this.dirty.put(key, new ExpungingValueImpl(value));
                    }
                }
            }
        }
        return result != null ? (V)result.getValue() : null;
    }

    public V replace(float key, @NonNull V value) {
        V previous;
        Objects.requireNonNull(value, "value");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        V v = previous = entry != null ? (V)entry.get() : null;
        if (entry != null && entry.trySet(value) || !this.readAmended) {
            return previous;
        }
        return this.putDirty(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(float key, @NonNull V oldValue, @NonNull V newValue) {
        Objects.requireNonNull(oldValue, "oldValue");
        Objects.requireNonNull(newValue, "newValue");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    if (entry != null && !entry.replace(oldValue, newValue)) {
                        entry = null;
                    }
                    this.missLocked();
                    return entry != null;
                }
            }
        }
        return entry != null && entry.replace(oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.read = this.function.apply(this.read.size());
            this.readAmended = false;
            this.dirty = null;
            this.readMisses = 0;
        }
    }

    @Override
    public @NonNull ObjectSet<// Could not load outer class - annotation placement on inner may be incorrect
    Float2ObjectMap.Entry<V>> float2ObjectEntrySet() {
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promoteIfNeeded() {
        if (this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                if (this.readAmended) {
                    this.promoteLocked();
                }
            }
        }
    }

    private void promoteLocked() {
        if (this.dirty != null) {
            this.read = this.dirty;
        }
        this.readAmended = false;
        this.dirty = null;
        this.readMisses = 0;
    }

    private void missLocked() {
        if (++this.readMisses > (this.dirty != null ? this.dirty.size() : 0)) {
            this.promoteLocked();
        }
    }

    private void dirtyLocked() {
        if (this.dirty != null) {
            return;
        }
        this.dirty = this.function.apply(this.read.size());
        Float2ObjectMaps.fastForEach(this.read, entry -> {
            if (!((Float2ObjectSyncMap.ExpungingValue)entry.getValue()).tryMarkExpunged()) {
                this.dirty.put(entry.getFloatKey(), (Object)((Float2ObjectSyncMap.ExpungingValue)entry.getValue()));
            }
        });
    }

    private final class EntryIterator
    implements ObjectIterator<Float2ObjectMap.Entry<V>> {
        private final Iterator<Float2ObjectMap.Entry<Float2ObjectSyncMap.ExpungingValue<V>>> backingIterator;
        private Float2ObjectMap.Entry<V> next;
        private Float2ObjectMap.Entry<V> current;

        private EntryIterator(Iterator<Float2ObjectMap.Entry<Float2ObjectSyncMap.ExpungingValue<V>>> backingIterator) {
            this.backingIterator = backingIterator;
            Float2ObjectMap.Entry entry = this.getNextValue();
            this.next = entry != null ? new MapEntry(entry) : null;
        }

        private Float2ObjectMap.Entry<Float2ObjectSyncMap.ExpungingValue<V>> getNextValue() {
            Float2ObjectMap.Entry entry = null;
            while (this.backingIterator.hasNext() && entry == null) {
                entry = this.backingIterator.next();
                Float2ObjectSyncMap.ExpungingValue value = (Float2ObjectSyncMap.ExpungingValue)entry.getValue();
                if (value.exists()) continue;
                entry = null;
            }
            return entry;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Float2ObjectMap.Entry<V> next() {
            this.current = this.next;
            Float2ObjectMap.Entry entry = this.getNextValue();
            MapEntry mapEntry = this.next = entry != null ? new MapEntry(entry) : null;
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        public void remove() {
            if (this.current == null) {
                return;
            }
            Float2ObjectSyncMapImpl.this.remove(this.current.getFloatKey());
        }

        public void forEachRemaining(@NonNull Consumer<? super // Could not load outer class - annotation placement on inner may be incorrect
        Float2ObjectMap.Entry<V>> action) {
            if (this.next != null) {
                action.accept(this.next);
            }
            this.backingIterator.forEachRemaining((? super E entry) -> {
                if (((Float2ObjectSyncMap.ExpungingValue)entry.getValue()).exists()) {
                    action.accept(new MapEntry((Float2ObjectMap.Entry)entry));
                }
            });
        }
    }

    private final class EntrySet
    extends AbstractObjectSet<Float2ObjectMap.Entry<V>> {
        private EntrySet() {
        }

        public int size() {
            return Float2ObjectSyncMapImpl.this.size();
        }

        public boolean contains(@Nullable Object entry) {
            if (!(entry instanceof Float2ObjectMap.Entry)) {
                return false;
            }
            Float2ObjectMap.Entry mapEntry = (Float2ObjectMap.Entry)entry;
            Object value = Float2ObjectSyncMapImpl.this.get(mapEntry.getFloatKey());
            return value != null && Objects.equals(value, mapEntry.getValue());
        }

        public boolean remove(@Nullable Object entry) {
            if (!(entry instanceof Float2ObjectMap.Entry)) {
                return false;
            }
            Float2ObjectMap.Entry mapEntry = (Float2ObjectMap.Entry)entry;
            return Float2ObjectSyncMapImpl.this.remove(mapEntry.getFloatKey()) != null;
        }

        public void clear() {
            Float2ObjectSyncMapImpl.this.clear();
        }

        public @NonNull ObjectIterator<// Could not load outer class - annotation placement on inner may be incorrect
        Float2ObjectMap.Entry<V>> iterator() {
            Float2ObjectSyncMapImpl.this.promoteIfNeeded();
            return new EntryIterator((Iterator)Float2ObjectSyncMapImpl.this.read.float2ObjectEntrySet().iterator());
        }
    }

    private final class MapEntry
    implements Float2ObjectMap.Entry<V> {
        private final float key;

        private MapEntry(Float2ObjectMap.Entry<Float2ObjectSyncMap.ExpungingValue<V>> entry) {
            this.key = entry.getFloatKey();
        }

        public float getFloatKey() {
            return this.key;
        }

        public @Nullable V getValue() {
            return Float2ObjectSyncMapImpl.this.get(this.key);
        }

        public @Nullable V setValue(@NonNull V value) {
            return Float2ObjectSyncMapImpl.this.put(this.key, value);
        }

        public @NonNull String toString() {
            return "Float2ObjectSyncMapImpl.MapEntry{key=" + this.getFloatKey() + ", value=" + this.getValue() + "}";
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Float2ObjectMap.Entry)) {
                return false;
            }
            Float2ObjectMap.Entry that = (Float2ObjectMap.Entry)other;
            return Objects.equals(Float.valueOf(this.getFloatKey()), Float.valueOf(that.getFloatKey())) && Objects.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.getFloatKey()), this.getValue());
        }
    }

    private static final class ExpungingValueImpl<V>
    implements Float2ObjectSyncMap.ExpungingValue<V> {
        private static final AtomicReferenceFieldUpdater<ExpungingValueImpl, Object> VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ExpungingValueImpl.class, Object.class, "value");
        private static final Object EXPUNGED = new Object();
        private volatile Object value;

        private ExpungingValueImpl(@NonNull V value) {
            this.value = value;
        }

        @Override
        public @Nullable V get() {
            Object value = VALUE_UPDATER.get(this);
            return (V)(value == EXPUNGED ? null : value);
        }

        @Override
        public  @NonNull Map.Entry<Boolean, V> putIfAbsent(@NonNull V value) {
            do {
                Object previous;
                if ((previous = VALUE_UPDATER.get(this)) == EXPUNGED) {
                    return new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.FALSE, null);
                }
                if (previous == null) continue;
                return new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.TRUE, previous);
            } while (!VALUE_UPDATER.compareAndSet(this, null, value));
            return new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.TRUE, null);
        }

        @Override
        public boolean expunged() {
            return VALUE_UPDATER.get(this) == EXPUNGED;
        }

        @Override
        public boolean exists() {
            Object value = VALUE_UPDATER.get(this);
            return value != null && value != EXPUNGED;
        }

        @Override
        public void set(@NonNull V value) {
            VALUE_UPDATER.set(this, value);
        }

        @Override
        public boolean replace(@NonNull Object compare, @Nullable V newValue) {
            Object value;
            do {
                if ((value = VALUE_UPDATER.get(this)) != EXPUNGED && Objects.equals(value, compare)) continue;
                return false;
            } while (!VALUE_UPDATER.compareAndSet(this, value, newValue));
            return true;
        }

        @Override
        public @Nullable V clear() {
            Object value;
            do {
                if ((value = VALUE_UPDATER.get(this)) != null && value != EXPUNGED) continue;
                return null;
            } while (!VALUE_UPDATER.compareAndSet(this, value, null));
            return (V)value;
        }

        @Override
        public boolean trySet(@NonNull V value) {
            Object present;
            do {
                if ((present = VALUE_UPDATER.get(this)) != EXPUNGED) continue;
                return false;
            } while (!VALUE_UPDATER.compareAndSet(this, present, value));
            return true;
        }

        @Override
        public boolean tryMarkExpunged() {
            Object value = VALUE_UPDATER.get(this);
            while (value == null) {
                if (VALUE_UPDATER.compareAndSet(this, null, EXPUNGED)) {
                    return true;
                }
                value = VALUE_UPDATER.get(this);
            }
            return false;
        }

        @Override
        public boolean tryUnexpungeAndSet(@Nullable V value) {
            return VALUE_UPDATER.compareAndSet(this, EXPUNGED, value);
        }

        public String toString() {
            return "Float2ObjectSyncMapImpl.ExpungingValue{value=" + this.get() + "}";
        }
    }
}

