/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Objects;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.MessageDigestInterceptedInputStream;
import space.iseki.hashutil.SHA512Serializer;
import space.iseki.hashutil.SharedUtil;

@Serializable(with=SHA512Serializer.class)
public final class SHA512 {
    private static final ThreadLocal<MessageDigest> threadLocal = ThreadLocal.withInitial(() -> SharedUtil.messageDigest("SHA512"));
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;
    private final int i4;
    private final int i5;
    private final int i6;
    private final int i7;
    private final int i8;
    private final int i9;
    private final int i10;
    private final int i11;
    private final int i12;
    private final int i13;
    private final int i14;
    private final int i15;

    @NotNull
    private static MessageDigest newDigest() {
        return SharedUtil.messageDigest("SHA512");
    }

    public SHA512(byte @NotNull [] arr, int off) {
        this.i0 = SharedUtil.AVH.get(arr, off + 0);
        this.i1 = SharedUtil.AVH.get(arr, off + 4);
        this.i2 = SharedUtil.AVH.get(arr, off + 8);
        this.i3 = SharedUtil.AVH.get(arr, off + 12);
        this.i4 = SharedUtil.AVH.get(arr, off + 16);
        this.i5 = SharedUtil.AVH.get(arr, off + 20);
        this.i6 = SharedUtil.AVH.get(arr, off + 24);
        this.i7 = SharedUtil.AVH.get(arr, off + 28);
        this.i8 = SharedUtil.AVH.get(arr, off + 32);
        this.i9 = SharedUtil.AVH.get(arr, off + 36);
        this.i10 = SharedUtil.AVH.get(arr, off + 40);
        this.i11 = SharedUtil.AVH.get(arr, off + 44);
        this.i12 = SharedUtil.AVH.get(arr, off + 48);
        this.i13 = SharedUtil.AVH.get(arr, off + 52);
        this.i14 = SharedUtil.AVH.get(arr, off + 56);
        this.i15 = SharedUtil.AVH.get(arr, off + 60);
    }

    public SHA512(byte @NotNull [] arr) {
        this(arr, 0);
    }

    public SHA512(@NotNull String hex) {
        this(HexFormat.of().parseHex(hex));
    }

    @NotNull
    static MessageDigest getThreadLocalDigest() {
        return threadLocal.get();
    }

    public byte @NotNull [] bytes(byte @NotNull [] arr, int off) {
        SharedUtil.AVH.set(arr, off + 0, this.i0);
        SharedUtil.AVH.set(arr, off + 4, this.i1);
        SharedUtil.AVH.set(arr, off + 8, this.i2);
        SharedUtil.AVH.set(arr, off + 12, this.i3);
        SharedUtil.AVH.set(arr, off + 16, this.i4);
        SharedUtil.AVH.set(arr, off + 20, this.i5);
        SharedUtil.AVH.set(arr, off + 24, this.i6);
        SharedUtil.AVH.set(arr, off + 28, this.i7);
        SharedUtil.AVH.set(arr, off + 32, this.i8);
        SharedUtil.AVH.set(arr, off + 36, this.i9);
        SharedUtil.AVH.set(arr, off + 40, this.i10);
        SharedUtil.AVH.set(arr, off + 44, this.i11);
        SharedUtil.AVH.set(arr, off + 48, this.i12);
        SharedUtil.AVH.set(arr, off + 52, this.i13);
        SharedUtil.AVH.set(arr, off + 56, this.i14);
        SharedUtil.AVH.set(arr, off + 60, this.i15);
        return arr;
    }

    public byte @NotNull [] bytes() {
        return this.bytes(new byte[64], 0);
    }

    @NotNull
    public String toString() {
        return HexFormat.of().formatHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SHA512 t = (SHA512)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3 && this.i4 == t.i4 && this.i5 == t.i5 && this.i6 == t.i6 && this.i7 == t.i7 && this.i8 == t.i8 && this.i9 == t.i9 && this.i10 == t.i10 && this.i11 == t.i11 && this.i12 == t.i12 && this.i13 == t.i13 && this.i14 == t.i14 && this.i15 == t.i15;
    }

    public int hashCode() {
        return Objects.hash(this.i0, this.i1, this.i2, this.i3, this.i4, this.i5, this.i6, this.i7, this.i8, this.i9, this.i10, this.i11, this.i12, this.i13, this.i14, this.i15);
    }

    @NotNull
    public static SHA512 of(@NotNull InputStream inputStream) throws IOException {
        return SharedUtil.forInputStream(SHA512.getThreadLocalDigest(), inputStream, SHA512::new);
    }

    @NotNull
    public static SHA512 of(@NotNull ReadableByteChannel channel) throws IOException {
        return SharedUtil.forReadableChannel(SHA512.getThreadLocalDigest(), channel, SHA512::new);
    }

    @NotNull
    public static SHA512 of(@NotNull Path path) throws IOException {
        return SharedUtil.forPath(SHA512.getThreadLocalDigest(), path, SHA512::new);
    }

    @NotNull
    public static SHA512 of(byte @NotNull [] data, int off, int len) {
        return SharedUtil.forBytes(SHA512.getThreadLocalDigest(), data, off, len, SHA512::new);
    }

    @NotNull
    public static SHA512 of(byte @NotNull [] data) {
        return SHA512.of(data, 0, data.length);
    }

    @NotNull
    public static MessageDigestInterceptedInputStream<SHA512> intercept(@NotNull InputStream inputStream) {
        return SharedUtil.forInterceptedInputStream(SHA512.newDigest(), inputStream, SHA512::new);
    }
}

