/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Objects;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.MessageDigestInterceptedInputStream;
import space.iseki.hashutil.SHA256Serializer;
import space.iseki.hashutil.SharedUtil;

@Serializable(with=SHA256Serializer.class)
public final class SHA256 {
    private static final ThreadLocal<MessageDigest> threadLocal = ThreadLocal.withInitial(() -> SharedUtil.messageDigest("SHA256"));
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;
    private final int i4;
    private final int i5;
    private final int i6;
    private final int i7;

    @NotNull
    private static MessageDigest newDigest() {
        return SharedUtil.messageDigest("SHA256");
    }

    public SHA256(byte @NotNull [] arr, int off) {
        this.i0 = SharedUtil.AVH.get(arr, off + 0);
        this.i1 = SharedUtil.AVH.get(arr, off + 4);
        this.i2 = SharedUtil.AVH.get(arr, off + 8);
        this.i3 = SharedUtil.AVH.get(arr, off + 12);
        this.i4 = SharedUtil.AVH.get(arr, off + 16);
        this.i5 = SharedUtil.AVH.get(arr, off + 20);
        this.i6 = SharedUtil.AVH.get(arr, off + 24);
        this.i7 = SharedUtil.AVH.get(arr, off + 28);
    }

    public SHA256(byte @NotNull [] arr) {
        this(arr, 0);
    }

    public SHA256(@NotNull String hex) {
        this(HexFormat.of().parseHex(hex));
    }

    @NotNull
    static MessageDigest getThreadLocalDigest() {
        return threadLocal.get();
    }

    public byte @NotNull [] bytes(byte @NotNull [] arr, int off) {
        SharedUtil.AVH.set(arr, off + 0, this.i0);
        SharedUtil.AVH.set(arr, off + 4, this.i1);
        SharedUtil.AVH.set(arr, off + 8, this.i2);
        SharedUtil.AVH.set(arr, off + 12, this.i3);
        SharedUtil.AVH.set(arr, off + 16, this.i4);
        SharedUtil.AVH.set(arr, off + 20, this.i5);
        SharedUtil.AVH.set(arr, off + 24, this.i6);
        SharedUtil.AVH.set(arr, off + 28, this.i7);
        return arr;
    }

    public byte @NotNull [] bytes() {
        return this.bytes(new byte[32], 0);
    }

    @NotNull
    public String toString() {
        return HexFormat.of().formatHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SHA256 t = (SHA256)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3 && this.i4 == t.i4 && this.i5 == t.i5 && this.i6 == t.i6 && this.i7 == t.i7;
    }

    public int hashCode() {
        return Objects.hash(this.i0, this.i1, this.i2, this.i3, this.i4, this.i5, this.i6, this.i7);
    }

    @NotNull
    public static SHA256 of(@NotNull InputStream inputStream) throws IOException {
        return SharedUtil.forInputStream(SHA256.getThreadLocalDigest(), inputStream, SHA256::new);
    }

    @NotNull
    public static SHA256 of(@NotNull ReadableByteChannel channel) throws IOException {
        return SharedUtil.forReadableChannel(SHA256.getThreadLocalDigest(), channel, SHA256::new);
    }

    @NotNull
    public static SHA256 of(@NotNull Path path) throws IOException {
        return SharedUtil.forPath(SHA256.getThreadLocalDigest(), path, SHA256::new);
    }

    @NotNull
    public static SHA256 of(byte @NotNull [] data, int off, int len) {
        return SharedUtil.forBytes(SHA256.getThreadLocalDigest(), data, off, len, SHA256::new);
    }

    @NotNull
    public static SHA256 of(byte @NotNull [] data) {
        return SHA256.of(data, 0, data.length);
    }

    @NotNull
    public static MessageDigestInterceptedInputStream<SHA256> intercept(@NotNull InputStream inputStream) {
        return SharedUtil.forInterceptedInputStream(SHA256.newDigest(), inputStream, SHA256::new);
    }
}

