/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Objects;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.MD2Serializer;
import space.iseki.hashutil.SharedUtil;

@Serializable(with=MD2Serializer.class)
public final class MD2 {
    private static final ThreadLocal<MessageDigest> threadLocal = ThreadLocal.withInitial(() -> SharedUtil.messageDigest("MD2"));
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;

    public MD2(byte @NotNull [] arr, int off) {
        this.i0 = SharedUtil.AVH.get(arr, off + 0);
        this.i1 = SharedUtil.AVH.get(arr, off + 4);
        this.i2 = SharedUtil.AVH.get(arr, off + 8);
        this.i3 = SharedUtil.AVH.get(arr, off + 12);
    }

    public MD2(byte @NotNull [] arr) {
        this(arr, 0);
    }

    public MD2(@NotNull String hex) {
        this(HexFormat.of().parseHex(hex));
    }

    @NotNull
    static MessageDigest getThreadLocalDigest() {
        return threadLocal.get();
    }

    public byte @NotNull [] bytes(byte @NotNull [] arr, int off) {
        SharedUtil.AVH.set(arr, off + 0, this.i0);
        SharedUtil.AVH.set(arr, off + 4, this.i1);
        SharedUtil.AVH.set(arr, off + 8, this.i2);
        SharedUtil.AVH.set(arr, off + 12, this.i3);
        return arr;
    }

    public byte @NotNull [] bytes() {
        return this.bytes(new byte[16], 0);
    }

    @NotNull
    public String toString() {
        return HexFormat.of().formatHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MD2 t = (MD2)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3;
    }

    public int hashCode() {
        return Objects.hash(this.i0, this.i1, this.i2, this.i3);
    }

    @NotNull
    public static MD2 of(@NotNull InputStream inputStream) throws IOException {
        return SharedUtil.forInputStream(MD2.getThreadLocalDigest(), inputStream, MD2::new);
    }

    @NotNull
    public static MD2 of(@NotNull ReadableByteChannel channel) throws IOException {
        return SharedUtil.forReadableChannel(MD2.getThreadLocalDigest(), channel, MD2::new);
    }

    @NotNull
    public static MD2 of(@NotNull Path path) throws IOException {
        return SharedUtil.forPath(MD2.getThreadLocalDigest(), path, MD2::new);
    }

    @NotNull
    public static MD2 of(byte @NotNull [] data, int off, int len) {
        return SharedUtil.forBytes(MD2.getThreadLocalDigest(), data, off, len, MD2::new);
    }

    @NotNull
    public static MD2 of(byte @NotNull [] data) {
        return MD2.of(data, 0, data.length);
    }
}

