/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.Algorithms;
import space.iseki.hashutil.Hash;
import space.iseki.hashutil.SHA512Serializer;
import space.iseki.hashutil.Util;

@Serializable(with=SHA512Serializer.class)
public final class SHA512
implements Hash {
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;
    private final int i4;
    private final int i5;
    private final int i6;
    private final int i7;
    private final int i8;
    private final int i9;
    private final int i10;
    private final int i11;
    private final int i12;
    private final int i13;
    private final int i14;
    private final int i15;

    public SHA512(@NotNull byte[] arr, int off) {
        this.i0 = Util.getInt(arr, off + 0);
        this.i1 = Util.getInt(arr, off + 4);
        this.i2 = Util.getInt(arr, off + 8);
        this.i3 = Util.getInt(arr, off + 12);
        this.i4 = Util.getInt(arr, off + 16);
        this.i5 = Util.getInt(arr, off + 20);
        this.i6 = Util.getInt(arr, off + 24);
        this.i7 = Util.getInt(arr, off + 28);
        this.i8 = Util.getInt(arr, off + 32);
        this.i9 = Util.getInt(arr, off + 36);
        this.i10 = Util.getInt(arr, off + 40);
        this.i11 = Util.getInt(arr, off + 44);
        this.i12 = Util.getInt(arr, off + 48);
        this.i13 = Util.getInt(arr, off + 52);
        this.i14 = Util.getInt(arr, off + 56);
        this.i15 = Util.getInt(arr, off + 60);
    }

    public SHA512(@NotNull byte[] arr) {
        this(arr, 0);
    }

    public SHA512(@NotNull String hex) {
        this(Util.decodeHex(hex));
    }

    @Override
    @NotNull
    public byte[] bytes(@NotNull byte[] arr, int off) {
        Util.putInt(arr, off + 0, this.i0);
        Util.putInt(arr, off + 4, this.i1);
        Util.putInt(arr, off + 8, this.i2);
        Util.putInt(arr, off + 12, this.i3);
        Util.putInt(arr, off + 16, this.i4);
        Util.putInt(arr, off + 20, this.i5);
        Util.putInt(arr, off + 24, this.i6);
        Util.putInt(arr, off + 28, this.i7);
        Util.putInt(arr, off + 32, this.i8);
        Util.putInt(arr, off + 36, this.i9);
        Util.putInt(arr, off + 40, this.i10);
        Util.putInt(arr, off + 44, this.i11);
        Util.putInt(arr, off + 48, this.i12);
        Util.putInt(arr, off + 52, this.i13);
        Util.putInt(arr, off + 56, this.i14);
        Util.putInt(arr, off + 60, this.i15);
        return arr;
    }

    @Override
    @NotNull
    public byte[] bytes() {
        return this.bytes(new byte[16], 0);
    }

    @NotNull
    public String toString() {
        return Util.encodeHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SHA512 t = (SHA512)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3 && this.i4 == t.i4 && this.i5 == t.i5 && this.i6 == t.i6 && this.i7 == t.i7 && this.i8 == t.i8 && this.i9 == t.i9 && this.i10 == t.i10 && this.i11 == t.i11 && this.i12 == t.i12 && this.i13 == t.i13 && this.i14 == t.i14 && this.i15 == t.i15;
    }

    @Override
    @NotNull
    public Algorithms kind() {
        return Algorithms.SHA512;
    }

    public int hashCode() {
        return Objects.hash(this.i0, this.i1, this.i2, this.i3, this.i4, this.i5, this.i6, this.i7, this.i8, this.i9, this.i10, this.i11, this.i12, this.i13, this.i14, this.i15);
    }

    @NotNull
    public static MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA512");
    }
}

