/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.nexusartifactuploader.steps;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import jenkins.MasterToSlaveFileCallable;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import sp.sd.nexusartifactuploader.Utils;

public final class NexusArtifactUploaderStep
extends AbstractStepImpl {
    private final String nexusVersion;
    private final String protocol;
    private final String nexusUrl;
    private final String nexusUser;
    private final String nexusPassword;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private final String classifier;
    private final String repository;
    private final String file;
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public NexusArtifactUploaderStep(String nexusVersion, String protocol, String nexusUrl, String nexusUser, String nexusPassword, String groupId, String artifactId, String version, String type, String classifier, String repository, String file, String credentialsId) {
        this.nexusVersion = nexusVersion;
        this.protocol = protocol;
        this.nexusUrl = nexusUrl;
        this.nexusUser = nexusUser;
        this.nexusPassword = Secret.fromString((String)nexusPassword).getEncryptedValue();
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
        this.repository = repository;
        this.file = file;
        this.credentialsId = credentialsId;
    }

    public String getNexusVersion() {
        return this.nexusVersion;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public String getNexusUser() {
        return this.nexusUser;
    }

    public String getNexusPassword() {
        return Secret.decrypt((String)this.nexusPassword).getPlainText();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getFile() {
        return this.file;
    }

    @Nullable
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public StandardUsernameCredentials getCredentials(Item project) {
        StandardUsernameCredentials credentials = null;
        try {
            StandardUsernameCredentials standardUsernameCredentials = this.credentialsId == null ? null : (credentials = NexusArtifactUploaderStep.lookupSystemCredentials(this.credentialsId, project));
            if (credentials != null) {
                return credentials;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return credentials;
    }

    public static StandardUsernameCredentials lookupSystemCredentials(String credentialsId, Item project) {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public String getUsername(EnvVars environment, Item project) {
        String Username = null;
        Username = Strings.isNullOrEmpty((String)this.nexusUser) ? "" : environment.expand(this.nexusUser);
        if (!Strings.isNullOrEmpty((String)this.credentialsId)) {
            Username = this.getCredentials(project).getUsername();
        }
        return Username;
    }

    public String getPassword(EnvVars environment, Item project) {
        String Password = null;
        Password = this.nexusPassword == null ? "" : environment.expand(Secret.decrypt((String)this.nexusPassword).getPlainText());
        if (!Strings.isNullOrEmpty((String)this.credentialsId)) {
            Password = Secret.toString((Secret)((StandardUsernamePasswordCredentials)StandardUsernamePasswordCredentials.class.cast(this.getCredentials(project))).getPassword());
        }
        return Password;
    }

    private static final class ArtifactFileCallable
    extends MasterToSlaveFileCallable<Boolean> {
        private final TaskListener listener;
        private final String resolvedNexusUser;
        private final String resolvedNexusPassword;
        private final String resolvedNexusUrl;
        private final String resolvedGroupId;
        private final String resolvedArtifactId;
        private final String resolvedVersion;
        private final String resolvedRepository;
        private final String resolvedType;
        private final String resolvedClassifier;
        private final String resolvedProtocol;
        private final String resolvedNexusVersion;

        public ArtifactFileCallable(TaskListener Listener, String ResolvedNexusUser, String ResolvedNexusPassword, String ResolvedNexusUrl, String ResolvedGroupId, String ResolvedArtifactId, String ResolvedVersion, String ResolvedRepository, String ResolvedType, String ResolvedClassifier, String ResolvedProtocol, String ResolvedNexusVersion) {
            this.listener = Listener;
            this.resolvedNexusUser = ResolvedNexusUser;
            this.resolvedNexusPassword = ResolvedNexusPassword;
            this.resolvedNexusUrl = ResolvedNexusUrl;
            this.resolvedGroupId = ResolvedGroupId;
            this.resolvedArtifactId = ResolvedArtifactId;
            this.resolvedVersion = ResolvedVersion;
            this.resolvedRepository = ResolvedRepository;
            this.resolvedType = ResolvedType;
            this.resolvedClassifier = ResolvedClassifier;
            this.resolvedProtocol = ResolvedProtocol;
            this.resolvedNexusVersion = ResolvedNexusVersion;
        }

        public Boolean invoke(File artifactFile, VirtualChannel channel) throws IOException {
            return Utils.uploadArtifact(artifactFile, this.listener, this.resolvedNexusUser, this.resolvedNexusPassword, this.resolvedNexusUrl, this.resolvedGroupId, this.resolvedArtifactId, this.resolvedVersion, this.resolvedRepository, this.resolvedType, this.resolvedClassifier, this.resolvedProtocol, this.resolvedNexusVersion);
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        @Inject
        private transient NexusArtifactUploaderStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient Launcher launcher;
        private static final long serialVersionUID = 1L;

        protected Boolean run() throws Exception {
            Boolean result = false;
            Job project = this.build.getParent();
            EnvVars envVars = this.build.getEnvironment(this.listener);
            FilePath artifactFilePath = new FilePath(this.ws, this.build.getEnvironment(this.listener).expand(this.step.getFile()));
            if (!artifactFilePath.exists()) {
                this.listener.getLogger().println(artifactFilePath.getName() + " file doesn't exists");
                throw new IOException(artifactFilePath.getName() + " file doesn't exists");
            }
            result = (Boolean)artifactFilePath.act((FilePath.FileCallable)new ArtifactFileCallable(this.listener, this.step.getUsername(envVars, (Item)project), this.step.getPassword(envVars, (Item)project), envVars.expand(this.step.getNexusUrl()), envVars.expand(this.step.getGroupId()), envVars.expand(this.step.getArtifactId()), envVars.expand(this.step.getVersion()), envVars.expand(this.step.getRepository()), envVars.expand(this.step.getType()), envVars.expand(this.step.getClassifier()), this.step.getProtocol(), this.step.getNexusVersion()));
            return result;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "nexusArtifactUploader";
        }

        public String getDisplayName() {
            return "Nexus non-maven artifacts uploader";
        }

        public FormValidation doCheckNexusUrl(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"URL must not be empty");
            }
            if (value.startsWith("http://") || value.startsWith("https://")) {
                return FormValidation.error((String)"URL must not start with http:// or https://");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGroupId(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"GroupId must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckArtifactId(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"ArtifactId must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersion(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Version must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckType(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Type must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckClassifier(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckRepository(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Repository must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFile(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"File must not be empty");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item owner) {
            if (owner == null || !owner.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardUsernameListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }
    }
}

