/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.nexusartifactuploader;

import com.google.common.base.Strings;
import hudson.model.TaskListener;
import java.io.File;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import sp.sd.nexusartifactuploader.Artifact;
import sp.sd.nexusartifactuploader.ArtifactRepositoryManager;

public final class Utils {
    private Utils() {
    }

    public static org.sonatype.aether.artifact.Artifact toArtifact(Artifact artifact, String groupId, String version, File artifactFile) {
        return new DefaultArtifact(groupId, artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), version).setFile(artifactFile);
    }

    public static Boolean uploadArtifacts(TaskListener Listener, String ResolvedNexusUser, String ResolvedNexusPassword, String ResolvedNexusUrl, String ResolvedRepository, String ResolvedProtocol, String ResolvedNexusVersion, org.sonatype.aether.artifact.Artifact ... artifacts) {
        Boolean result = false;
        if (Strings.isNullOrEmpty((String)ResolvedNexusUrl)) {
            Listener.getLogger().println("Url of the Nexus is empty. Please enter Nexus Url.");
            return false;
        }
        try {
            for (org.sonatype.aether.artifact.Artifact artifact : artifacts) {
                Listener.getLogger().println("Uploading artifact " + artifact.getFile().getName() + " started....");
                Listener.getLogger().println("GroupId: " + artifact.getGroupId());
                Listener.getLogger().println("ArtifactId: " + artifact.getGroupId());
                Listener.getLogger().println("Classifier: " + artifact.getClassifier());
                Listener.getLogger().println("Type: " + artifact.getExtension());
                Listener.getLogger().println("Version: " + artifact.getVersion());
                Listener.getLogger().println("File: " + artifact.getFile().getName());
                Listener.getLogger().println("Repository:" + ResolvedRepository);
            }
            String repositoryPath = "/content/repositories/";
            if (ResolvedNexusVersion.contentEquals("nexus3")) {
                repositoryPath = "/repository/";
            }
            ArtifactRepositoryManager artifactRepositoryManager = new ArtifactRepositoryManager(ResolvedProtocol + "://" + ResolvedNexusUrl + repositoryPath + ResolvedRepository, ResolvedNexusUser, ResolvedNexusPassword, ResolvedRepository, Listener);
            artifactRepositoryManager.upload(artifacts);
            for (org.sonatype.aether.artifact.Artifact artifact : artifacts) {
                Listener.getLogger().println("Uploading artifact " + artifact.getFile().getName() + " completed.");
            }
            result = true;
        }
        catch (Exception e) {
            Listener.getLogger().println(e.getMessage());
        }
        return result;
    }
}

