/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.nexusartifactuploader;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ProminentProjectAction;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class NexusArtifactUploader
extends Builder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String protocol;
    private final String nexusUrl;
    private final String nexusUser;
    private final Secret nexusPassword;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String packaging;
    private final String repository;
    private final String file;
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public NexusArtifactUploader(String protocol, String nexusUrl, String nexusUser, Secret nexusPassword, String groupId, String artifactId, String version, String packaging, String repository, String file, String credentialsId) {
        this.protocol = protocol;
        this.nexusUrl = nexusUrl;
        this.nexusUser = nexusUser;
        this.nexusPassword = nexusPassword;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packaging = packaging;
        this.repository = repository;
        this.file = file;
        this.credentialsId = credentialsId;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public String getNexusUser() {
        return this.nexusUser;
    }

    public Secret getNexusPassword() {
        return this.nexusPassword;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getFile() {
        return this.file;
    }

    @Nullable
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public StandardUsernameCredentials getCredentials() {
        StandardUsernameCredentials credentials = null;
        try {
            StandardUsernameCredentials standardUsernameCredentials = this.credentialsId == null ? null : (credentials = NexusArtifactUploader.lookupSystemCredentials(this.credentialsId));
            if (credentials != null) {
                return credentials;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return credentials;
    }

    public static StandardUsernameCredentials lookupSystemCredentials(String credentialsId) {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public String getUsername(EnvVars environment) {
        String Username = null;
        Username = Strings.isNullOrEmpty((String)this.nexusUser) ? "" : environment.expand(this.nexusUser);
        if (!Strings.isNullOrEmpty((String)this.credentialsId)) {
            Username = this.getCredentials().getUsername();
        }
        return Username;
    }

    public String getPassword(EnvVars environment) {
        String Password = null;
        Password = this.nexusPassword == null ? "" : environment.expand(Secret.toString((Secret)this.nexusPassword));
        if (!Strings.isNullOrEmpty((String)this.credentialsId)) {
            Password = Secret.toString((Secret)((StandardUsernamePasswordCredentials)StandardUsernamePasswordCredentials.class.cast(this.getCredentials())).getPassword());
        }
        return Password;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        boolean result = false;
        try {
            FilePath artifactFilePath = new FilePath(build.getWorkspace(), build.getEnvironment((TaskListener)listener).expand(this.file));
            try {
                if (!artifactFilePath.exists()) {
                    listener.getLogger().println(artifactFilePath.getName() + " file doesn't exists");
                    return false;
                }
            }
            catch (RuntimeException e) {
                listener.getLogger().println(artifactFilePath.getName() + " file doesn't exists");
                throw e;
            }
            catch (Exception e) {
                listener.getLogger().println(artifactFilePath.getName() + " file doesn't exists");
                return false;
            }
            try {
                result = (Boolean)artifactFilePath.act((FilePath.FileCallable)new ArtifactFileCallable(listener, this.getUsername(build.getEnvironment((TaskListener)listener)), this.getPassword(build.getEnvironment((TaskListener)listener)), build.getEnvironment((TaskListener)listener).expand(this.nexusUrl), build.getEnvironment((TaskListener)listener).expand(this.groupId), build.getEnvironment((TaskListener)listener).expand(this.artifactId), build.getEnvironment((TaskListener)listener).expand(this.version), build.getEnvironment((TaskListener)listener).expand(this.repository), build.getEnvironment((TaskListener)listener).expand(this.packaging), this.protocol));
            }
            catch (Exception e) {
                e.printStackTrace(listener.getLogger());
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(listener.getLogger());
        }
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl<C extends StandardCredentials>
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Upload artifact to nexus";
        }

        public FormValidation doCheckNexusUrl(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"URL must not be empty");
            }
            if (value.startsWith("http://") || value.startsWith("https://")) {
                return FormValidation.error((String)"URL must not start with http:// or https://");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGroupId(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"GroupId must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckArtifactId(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"ArtifactId must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersion(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Version must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPackaging(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Packaging must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRepository(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Repository must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFile(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"File must not be empty");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item owner) {
            if (owner == null || !owner.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardUsernameListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }
    }

    public static final class LinkAction
    implements Action,
    ProminentProjectAction {
        private final String name;
        private final String url;
        private final String icon;

        public LinkAction(String ResolvedNexusUrl, String ResolvedGroupId, String ResolvedArtifactId, String ResolvedVersion, String ResolvedRepository, String ResolvedPackaging, String ResolvedProtocol, String Name) {
            this.name = Name;
            this.url = ResolvedProtocol + "://" + ResolvedNexusUrl + "/service/local/repositories/" + ResolvedRepository + "/content/" + ResolvedGroupId.replace('.', '/') + "/" + ResolvedArtifactId + "/" + ResolvedVersion + "/" + ResolvedArtifactId + "-" + ResolvedVersion + "." + ResolvedPackaging;
            this.icon = "package.gif";
        }

        public String getIconFileName() {
            return this.icon;
        }

        public String getDisplayName() {
            return this.name;
        }

        public String getUrlName() {
            return this.url;
        }
    }

    private static final class ArtifactFileCallable
    implements FilePath.FileCallable<Boolean> {
        private final BuildListener listener;
        private final String resolvedNexusUser;
        private final String resolvedNexusPassword;
        private final String resolvedNexusUrl;
        private final String resolvedGroupId;
        private final String resolvedArtifactId;
        private final String resolvedVersion;
        private final String resolvedRepository;
        private final String resolvedPackaging;
        private final String resolvedProtocol;

        public ArtifactFileCallable(BuildListener Listener, String ResolvedNexusUser, String ResolvedNexusPassword, String ResolvedNexusUrl, String ResolvedGroupId, String ResolvedArtifactId, String ResolvedVersion, String ResolvedRepository, String ResolvedPackaging, String ResolvedProtocol) {
            this.listener = Listener;
            this.resolvedNexusUser = ResolvedNexusUser;
            this.resolvedNexusPassword = ResolvedNexusPassword;
            this.resolvedNexusUrl = ResolvedNexusUrl;
            this.resolvedGroupId = ResolvedGroupId;
            this.resolvedArtifactId = ResolvedArtifactId;
            this.resolvedVersion = ResolvedVersion;
            this.resolvedRepository = ResolvedRepository;
            this.resolvedPackaging = ResolvedPackaging;
            this.resolvedProtocol = ResolvedProtocol;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Boolean invoke(File artifactFile, VirtualChannel channel) {
            boolean result = false;
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                if (Strings.isNullOrEmpty((String)this.resolvedNexusUrl)) {
                    this.listener.getLogger().println("Url of the Nexus is empty. Please enter Nexus Url.");
                    Boolean bl = false;
                    return bl;
                }
                HttpPost httpPost = new HttpPost(this.resolvedProtocol + "://" + this.resolvedNexusUser + ":" + this.resolvedNexusPassword + "@" + this.resolvedNexusUrl + "/service/local/artifact/maven/content");
                this.listener.getLogger().println("GroupId: " + this.resolvedGroupId);
                this.listener.getLogger().println("ArtifactId: " + this.resolvedArtifactId);
                this.listener.getLogger().println("Version: " + this.resolvedVersion);
                this.listener.getLogger().println("File: " + artifactFile.getName());
                this.listener.getLogger().println("Repository:" + this.resolvedRepository);
                this.listener.getLogger().println("Uploading artifact " + artifactFile.getName() + " started....");
                FileBody artifactFileBody = new FileBody(artifactFile);
                HttpEntity requestEntity = MultipartEntityBuilder.create().addPart("r", (ContentBody)new StringBody(this.resolvedRepository, ContentType.TEXT_PLAIN)).addPart("hasPom", (ContentBody)new StringBody("false", ContentType.TEXT_PLAIN)).addPart("e", (ContentBody)new StringBody(this.resolvedPackaging, ContentType.TEXT_PLAIN)).addPart("g", (ContentBody)new StringBody(this.resolvedGroupId, ContentType.TEXT_PLAIN)).addPart("a", (ContentBody)new StringBody(this.resolvedArtifactId, ContentType.TEXT_PLAIN)).addPart("v", (ContentBody)new StringBody(this.resolvedVersion, ContentType.TEXT_PLAIN)).addPart("p", (ContentBody)new StringBody(this.resolvedPackaging, ContentType.TEXT_PLAIN)).addPart("file", (ContentBody)artifactFileBody).build();
                httpPost.setEntity(requestEntity);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 201) {
                        result = true;
                        this.listener.getLogger().println("Uploading artifact " + artifactFile.getName() + " completed.");
                        return result;
                    }
                    this.listener.getLogger().println("Reason Phrase: " + response.getStatusLine().getReasonPhrase());
                    HttpEntity entity = response.getEntity();
                    String content = EntityUtils.toString((HttpEntity)entity);
                    this.listener.getLogger().println(content);
                    result = false;
                    return result;
                }
            }
            catch (RuntimeException e) {
                this.listener.getLogger().println(e.getMessage());
                e.printStackTrace(this.listener.getLogger());
                throw e;
            }
            catch (Exception e) {
                this.listener.getLogger().println(e.getMessage());
                e.printStackTrace(this.listener.getLogger());
            }
            return result;
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }
}

