/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.fileoperations;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import sp.sd.fileoperations.FileOperation;
import sp.sd.fileoperations.FileOperationDescriptor;

public class FilePropertiesToJsonOperation
extends FileOperation
implements Serializable {
    private final String sourceFile;
    private final String targetFile;

    @DataBoundConstructor
    public FilePropertiesToJsonOperation(String sourceFile, String targetFile) {
        this.sourceFile = sourceFile;
        this.targetFile = targetFile;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    @Override
    public boolean runOperation(Run<?, ?> run, FilePath buildWorkspace, Launcher launcher, TaskListener listener) {
        boolean result = false;
        try {
            listener.getLogger().println("File Properties To Json Operation:");
            EnvVars envVars = run.getEnvironment(listener);
            try {
                FilePath ws = new FilePath(buildWorkspace, ".");
                result = (Boolean)ws.act((FilePath.FileCallable)new TargetFileCallable(listener, envVars.expand(this.sourceFile), envVars.expand(this.targetFile), envVars));
            }
            catch (Exception e) {
                listener.fatalError(e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            listener.fatalError(e.getMessage());
        }
        return result;
    }

    @Extension
    @Symbol(value={"filePropertiesToJsonOperation"})
    public static class DescriptorImpl
    extends FileOperationDescriptor {
        public String getDisplayName() {
            return "File Properties to Json";
        }
    }

    private static final class TargetFileCallable
    implements FilePath.FileCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;
        private final EnvVars environment;
        private final String resolvedSourceFile;
        private final String resolvedTargetFile;
        private static final Pattern floatPattern = Pattern.compile("^[0-9]+(\\.[0-9]+)?$");
        private static final Pattern intPattern = Pattern.compile("^[0-9]+$");

        public TargetFileCallable(TaskListener Listener, String ResolvedSourceFile, String ResolvedTargetFile, EnvVars environment) {
            this.listener = Listener;
            this.resolvedSourceFile = ResolvedSourceFile;
            this.resolvedTargetFile = ResolvedTargetFile;
            this.environment = environment;
        }

        public Boolean invoke(File ws, VirtualChannel channel) {
            boolean result = false;
            try {
                FilePath fpWS = new FilePath(ws);
                FilePath fpSL = new FilePath(fpWS, this.resolvedSourceFile);
                FilePath fpTL = new FilePath(fpWS, this.resolvedTargetFile);
                if (!fpTL.exists()) {
                    this.listener.getLogger().println(this.resolvedSourceFile + " file doesn't exists, the target file remains as is.");
                } else {
                    String fileContent = "";
                    Properties sourceProperties = new Properties();
                    sourceProperties.load(fpSL.read());
                    fpTL.write(TargetFileCallable.convertToJson(sourceProperties), "UTF-8");
                    result = true;
                    this.listener.getLogger().println("Creating Json: from source " + fpSL.getRemote() + " to target " + fpTL.getRemote());
                }
            }
            catch (RuntimeException e) {
                this.listener.fatalError(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.listener.fatalError(e.getMessage());
                result = false;
            }
            return result;
        }

        private static String convertToJson(Properties properties) {
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode json = objectMapper.createObjectNode();
            for (Object key : properties.keySet()) {
                String value = properties.getProperty(key.toString());
                if (value.equals("true") || value.equals("false")) {
                    json.put(key.toString(), Boolean.parseBoolean(value));
                    continue;
                }
                if (intPattern.matcher(value).matches()) {
                    json.put(key.toString(), Integer.parseInt(value));
                    continue;
                }
                if (floatPattern.matcher(value).matches()) {
                    json.put(key.toString(), Float.parseFloat(value));
                    continue;
                }
                json.put(key.toString(), value);
            }
            ObjectNode rootNode = json;
            return rootNode.toString();
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }
}

