/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.fileoperations;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.Secret;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.protocol.HttpContext;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import sp.sd.fileoperations.FileOperation;
import sp.sd.fileoperations.FileOperationDescriptor;

public class FileDownloadOperation
extends FileOperation
implements Serializable {
    private final String url;
    private final String userName;
    private final String targetLocation;
    private final String targetFileName;
    private final String password;
    private final String proxyHost;
    private final String proxyPort;

    @DataBoundConstructor
    public FileDownloadOperation(String url, String userName, String password, String targetLocation, String targetFileName, String proxyHost, String proxyPort) {
        this.url = url;
        this.userName = userName;
        this.targetLocation = targetLocation;
        this.targetFileName = targetFileName;
        this.password = Secret.fromString((String)password).getEncryptedValue();
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getTargetLocation() {
        return this.targetLocation;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public String getPassword() {
        return Secret.decrypt((String)this.password).getPlainText();
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public boolean runOperation(Run<?, ?> run, FilePath buildWorkspace, Launcher launcher, TaskListener listener) {
        boolean result = false;
        try {
            listener.getLogger().println("File Download Operation:");
            EnvVars envVars = run.getEnvironment(listener);
            try {
                FilePath ws = new FilePath(buildWorkspace, ".");
                result = (Boolean)ws.act((FilePath.FileCallable)new TargetFileCallable(listener, envVars.expand(this.url), envVars.expand(this.userName), envVars.expand(Secret.decrypt((String)this.password).getPlainText()), envVars.expand(this.targetLocation), envVars.expand(this.targetFileName), envVars.expand(this.proxyHost), envVars.expand(this.proxyPort)));
            }
            catch (Exception e) {
                listener.fatalError(e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            listener.fatalError(e.getMessage());
        }
        return result;
    }

    @Extension
    @Symbol(value={"fileDownloadOperation"})
    public static class DescriptorImpl
    extends FileOperationDescriptor {
        public String getDisplayName() {
            return "File Download";
        }
    }

    private static final class TargetFileCallable
    implements FilePath.FileCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;
        private final String resolvedUrl;
        private final String resolvedUserName;
        private final String resolvedTargetLocation;
        private final String resolvedTargetFileName;
        private final String resolvedPassword;
        private final String proxyHost;
        private final String proxyPort;

        public TargetFileCallable(TaskListener Listener, String ResolvedUrl, String ResolvedUserName, String ResolvedPassword, String ResolvedTargetLocation, String ResolvedTargetFileName, String proxyHost, String proxyPort) {
            this.listener = Listener;
            this.resolvedUrl = ResolvedUrl;
            this.resolvedUserName = ResolvedUserName;
            this.resolvedTargetLocation = ResolvedTargetLocation;
            this.resolvedTargetFileName = ResolvedTargetFileName;
            this.resolvedPassword = ResolvedPassword;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
        }

        public Boolean invoke(File ws, VirtualChannel channel) {
            boolean result;
            try {
                FilePath fpWS = new FilePath(ws);
                FilePath fpTL = new FilePath(fpWS, this.resolvedTargetLocation);
                FilePath fpTLF = new FilePath(fpTL, this.resolvedTargetFileName);
                File fTarget = new File(fpTLF.toURI());
                URI Url = new URI(this.resolvedUrl);
                this.listener.getLogger().println("Started downloading file from " + this.resolvedUrl);
                HttpHost host = new HttpHost(Url.getHost(), Url.getPort(), Url.getScheme());
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(Url.getHost(), Url.getPort()), (Credentials)new UsernamePasswordCredentials(this.resolvedUserName, this.resolvedPassword));
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(host, (AuthScheme)basicAuth);
                HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                if (this.proxyHost != null && !this.proxyHost.isEmpty() && this.proxyPort != null && this.proxyPort.matches("[0-9]+")) {
                    HttpHost proxy = new HttpHost(this.proxyHost, Integer.parseInt(this.proxyPort));
                    httpClientBuilder.setProxy(proxy);
                }
                CloseableHttpClient httpClient = httpClientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
                HttpGet httpGet = new HttpGet(Url);
                HttpClientContext localContext = HttpClientContext.create();
                if (!this.resolvedUserName.isEmpty() && !this.resolvedPassword.isEmpty()) {
                    localContext.setAuthCache((AuthCache)authCache);
                }
                CloseableHttpResponse response = httpClient.execute(host, (HttpRequest)httpGet, (HttpContext)localContext);
                HttpEntity entity = response.getEntity();
                try (FileOutputStream fosTarget = new FileOutputStream(fTarget);){
                    if (response.getStatusLine().getStatusCode() != 200) {
                        result = false;
                    } else {
                        entity.writeTo((OutputStream)fosTarget);
                        result = true;
                        this.listener.getLogger().println("Completed downloading file.");
                    }
                }
            }
            catch (RuntimeException e) {
                this.listener.fatalError(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.listener.fatalError(e.getMessage());
                result = false;
            }
            return result;
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }
}

