/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.fileoperations;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.Serializable;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import sp.sd.fileoperations.FileOperation;
import sp.sd.fileoperations.FileOperationDescriptor;

public class FileUnZipOperation
extends FileOperation
implements Serializable {
    private final String filePath;
    private final String targetLocation;

    @DataBoundConstructor
    public FileUnZipOperation(String filePath, String targetLocation) {
        this.filePath = filePath;
        this.targetLocation = targetLocation;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getTargetLocation() {
        return this.targetLocation;
    }

    @Override
    public boolean runOperation(Run<?, ?> run, FilePath buildWorkspace, Launcher launcher, TaskListener listener) {
        boolean result = false;
        try {
            listener.getLogger().println("Unzip File Operation:");
            EnvVars envVars = run.getEnvironment(listener);
            try {
                FilePath ws = new FilePath(buildWorkspace, ".");
                result = (Boolean)ws.act((FilePath.FileCallable)new TargetFileCallable(listener, envVars.expand(this.filePath), envVars.expand(this.targetLocation)));
            }
            catch (RuntimeException e) {
                listener.getLogger().println(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                listener.fatalError(e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            listener.fatalError(e.getMessage());
        }
        return result;
    }

    @Extension
    @Symbol(value={"fileUnZipOperation"})
    public static class DescriptorImpl
    extends FileOperationDescriptor {
        public String getDisplayName() {
            return "Unzip";
        }
    }

    private static final class TargetFileCallable
    implements FilePath.FileCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;
        private final String resolvedFilePath;
        private final String resolvedTargetLocation;

        public TargetFileCallable(TaskListener Listener, String ResolvedFilePath, String ResolvedTargetLocation) {
            this.listener = Listener;
            this.resolvedFilePath = ResolvedFilePath;
            this.resolvedTargetLocation = ResolvedTargetLocation;
        }

        public Boolean invoke(File ws, VirtualChannel channel) {
            boolean result = false;
            try {
                FilePath fpWS = new FilePath(ws);
                FilePath fpSrcZip = new FilePath(fpWS, this.resolvedFilePath);
                FilePath fpTL = new FilePath(fpWS, this.resolvedTargetLocation);
                this.listener.getLogger().println("Unzipping " + this.resolvedFilePath + " to " + fpTL.getRemote());
                if (!fpTL.exists()) {
                    fpTL.mkdirs();
                }
                fpSrcZip.unzip(fpTL);
                result = true;
                this.listener.getLogger().println("Unzip completed.");
            }
            catch (RuntimeException e) {
                this.listener.fatalError(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.listener.fatalError(e.getMessage());
                result = false;
            }
            return result;
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }
}

