/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.fileoperations;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import sp.sd.fileoperations.FileOperation;
import sp.sd.fileoperations.FileOperationDescriptor;

public class FileOperationsBuilder
extends Builder {
    private final List<FileOperation> fileOperations;

    @DataBoundConstructor
    public FileOperationsBuilder(List<FileOperation> fileOperations) {
        this.fileOperations = fileOperations == null ? new ArrayList<FileOperation>() : new ArrayList<FileOperation>(fileOperations);
    }

    public List<FileOperation> getFileOperations() {
        return Collections.unmodifiableList(this.fileOperations);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean result = false;
        if (this.fileOperations.size() > 0) {
            FileOperation item;
            Iterator<FileOperation> iterator = this.fileOperations.iterator();
            while (iterator.hasNext() && (result = (item = iterator.next()).runOperation((Run<?, ?>)build, build.getWorkspace(), launcher, (TaskListener)listener))) {
            }
        } else {
            listener.getLogger().println("No File Operation added.");
            result = true;
        }
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "File Operations";
        }

        public List<FileOperationDescriptor> getFileOperationDescriptors() {
            ArrayList<FileOperationDescriptor> result = new ArrayList<FileOperationDescriptor>();
            Jenkins j = Jenkins.getInstance();
            if (j == null) {
                return result;
            }
            for (Descriptor d : j.getDescriptorList(FileOperation.class)) {
                if (!(d instanceof FileOperationDescriptor)) continue;
                FileOperationDescriptor descriptor = (FileOperationDescriptor)d;
                result.add(descriptor);
            }
            return result;
        }
    }
}

