/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import java.util.List;
import java.util.stream.Collectors;
import software.xdev.mockserver.model.Cookies;
import software.xdev.mockserver.model.Headers;
import software.xdev.mockserver.model.HttpRequestModifier;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.model.Parameters;
import software.xdev.mockserver.serialization.java.CookieToJavaSerializer;
import software.xdev.mockserver.serialization.java.HeaderToJavaSerializer;
import software.xdev.mockserver.serialization.java.MultiValueToJavaSerializer;
import software.xdev.mockserver.serialization.java.ParameterToJavaSerializer;
import software.xdev.mockserver.serialization.java.ToJavaSerializer;

public class HttpRequestModifierToJavaSerializer
implements ToJavaSerializer<HttpRequestModifier> {
    public String serialize(List<HttpRequestModifier> httpRequestModifiers) {
        StringBuilder output = new StringBuilder(50);
        for (HttpRequestModifier httpRequestModifier : httpRequestModifiers) {
            output.append(this.serialize(0, httpRequestModifier)).append(';').append("\n");
        }
        return output.toString();
    }

    @Override
    public String serialize(int numberOfSpacesToIndent, HttpRequestModifier request) {
        StringBuilder output = new StringBuilder(20);
        if (request != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output);
            output.append("requestModifier()");
            if (request.getPath() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withPath(\"").append(request.getPath().getRegex()).append("\",\"").append(request.getPath().getSubstitution()).append("\")");
            }
            if (request.getQueryStringParameters() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withQueryStringParameters(");
                this.outputQueryStringParameters(numberOfSpacesToIndent, output, (Parameters)request.getQueryStringParameters().getAdd());
                this.outputQueryStringParameters(numberOfSpacesToIndent, output, (Parameters)request.getQueryStringParameters().getReplace());
                this.outputList(numberOfSpacesToIndent, output, request.getQueryStringParameters().getRemove());
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(')');
            }
            if (request.getHeaders() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withHeaders(");
                this.outputHeaders(numberOfSpacesToIndent, output, (Headers)request.getHeaders().getAdd());
                this.outputHeaders(numberOfSpacesToIndent, output, (Headers)request.getHeaders().getReplace());
                this.outputList(numberOfSpacesToIndent, output, request.getHeaders().getRemove());
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(')');
            }
            if (request.getCookies() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withCookies(");
                this.outputCookies(numberOfSpacesToIndent, output, (Cookies)request.getCookies().getAdd());
                this.outputCookies(numberOfSpacesToIndent, output, (Cookies)request.getCookies().getReplace());
                this.outputList(numberOfSpacesToIndent, output, request.getCookies().getRemove());
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(')');
            }
        }
        return output.toString();
    }

    private void outputQueryStringParameters(int numberOfSpacesToIndent, StringBuilder output, Parameters parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("parameters(");
            this.appendObject(numberOfSpacesToIndent + 2, output, new ParameterToJavaSerializer(), parameters.getEntries());
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("),");
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null,");
        }
    }

    private void outputHeaders(int numberOfSpacesToIndent, StringBuilder output, Headers headers) {
        if (headers != null && !headers.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("headers(");
            this.appendObject(numberOfSpacesToIndent + 2, output, new HeaderToJavaSerializer(), headers.getEntries());
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("),");
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null,");
        }
    }

    private void outputCookies(int numberOfSpacesToIndent, StringBuilder output, Cookies cookies) {
        if (cookies != null && !cookies.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("cookies(");
            this.appendObject(numberOfSpacesToIndent + 2, output, new CookieToJavaSerializer(), cookies.getEntries());
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("),");
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null,");
        }
    }

    private void outputList(int numberOfSpacesToIndent, StringBuilder output, List<String> add) {
        if (add != null && !add.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("List.of(").append(add.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","))).append(')');
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null");
        }
    }

    private <T extends ObjectWithJsonToString> void appendObject(int numberOfSpacesToIndent, StringBuilder output, MultiValueToJavaSerializer<T> toJavaSerializer, List<T> objects) {
        output.append(toJavaSerializer.serializeAsJava(numberOfSpacesToIndent + 1, objects));
    }

    private StringBuilder appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuilder output) {
        return output.append("\n").append(" ".repeat(numberOfSpacesToIndent));
    }
}

