/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import java.util.List;
import software.xdev.mockserver.mock.Expectation;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.serialization.java.HttpClassCallbackToJavaSerializer;
import software.xdev.mockserver.serialization.java.HttpErrorToJavaSerializer;
import software.xdev.mockserver.serialization.java.HttpForwardToJavaSerializer;
import software.xdev.mockserver.serialization.java.HttpOverrideForwardedRequestToJavaSerializer;
import software.xdev.mockserver.serialization.java.HttpRequestToJavaSerializer;
import software.xdev.mockserver.serialization.java.HttpResponseToJavaSerializer;
import software.xdev.mockserver.serialization.java.TimeToLiveToJavaSerializer;
import software.xdev.mockserver.serialization.java.TimesToJavaSerializer;
import software.xdev.mockserver.serialization.java.ToJavaSerializer;

public class ExpectationToJavaSerializer
implements ToJavaSerializer<Expectation> {
    public static final int INDENT_SIZE = 8;

    public String serialize(List<Expectation> expectations) {
        StringBuilder output = new StringBuilder();
        for (Expectation expectation : expectations) {
            output.append(this.serialize(0, expectation)).append("\n").append("\n");
        }
        return output.toString();
    }

    @Override
    public String serialize(int numberOfSpacesToIndent, Expectation expectation) {
        StringBuilder output = new StringBuilder();
        if (expectation != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("new MockServerClient(\"localhost\", 1080)");
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".when(");
            RequestDefinition requestDefinition = expectation.getHttpRequest();
            if (requestDefinition instanceof HttpRequest) {
                output.append(new HttpRequestToJavaSerializer().serialize(numberOfSpacesToIndent + 1, (HttpRequest)requestDefinition));
            }
            output.append(',');
            if (expectation.getTimes() != null) {
                output.append(new TimesToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getTimes()));
            } else {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append("null");
            }
            output.append(',');
            if (expectation.getTimeToLive() != null) {
                output.append(new TimeToLiveToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getTimeToLive()));
            } else {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append("null");
            }
            output.append(',');
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(expectation.getPriority());
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(')');
            if (expectation.getHttpResponse() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".respond(");
                output.append(new HttpResponseToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpResponse()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(')');
            }
            if (expectation.getHttpResponseClassCallback() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".respond(");
                output.append(new HttpClassCallbackToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpResponseClassCallback()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(')');
            }
            if (expectation.getHttpResponseObjectCallback() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("/*NOT POSSIBLE TO GENERATE CODE FOR OBJECT CALLBACK*/");
            }
            if (expectation.getHttpForward() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".forward(");
                output.append(new HttpForwardToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpForward()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(')');
            }
            if (expectation.getHttpOverrideForwardedRequest() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".forward(");
                output.append(new HttpOverrideForwardedRequestToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpOverrideForwardedRequest()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(')');
            }
            if (expectation.getHttpForwardClassCallback() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".forward(");
                output.append(new HttpClassCallbackToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpForwardClassCallback()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(')');
            }
            if (expectation.getHttpForwardObjectCallback() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("/*NOT POSSIBLE TO GENERATE CODE FOR OBJECT CALLBACK*/");
            }
            if (expectation.getHttpError() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".error(");
                output.append(new HttpErrorToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpError()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(')');
            }
            output.append(';');
        }
        return output.toString();
    }

    private StringBuilder appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuilder output) {
        return output.append("\n").append(" ".repeat(numberOfSpacesToIndent));
    }
}

