/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.lifecycle;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.lifecycle.ExpectationsListener;
import software.xdev.mockserver.mock.HttpState;
import software.xdev.mockserver.mock.RequestMatchers;
import software.xdev.mockserver.mock.listeners.MockServerMatcherNotifier;
import software.xdev.mockserver.scheduler.Scheduler;
import software.xdev.mockserver.scheduler.SchedulerThreadFactory;
import software.xdev.mockserver.stop.Stoppable;
import software.xdev.mockserver.util.StringUtils;

public abstract class LifeCycle
implements Stoppable {
    private static final Logger LOG = LoggerFactory.getLogger(LifeCycle.class);
    protected final EventLoopGroup bossGroup;
    protected final EventLoopGroup workerGroup;
    protected final HttpState httpState;
    private final ServerConfiguration configuration;
    protected ServerBootstrap serverServerBootstrap;
    private final List<Future<Channel>> serverChannelFutures = new ArrayList<Future<Channel>>();
    private final CompletableFuture<String> stopFuture = new CompletableFuture();
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final Scheduler scheduler;

    protected LifeCycle(ServerConfiguration configuration) {
        this.configuration = configuration != null ? configuration : ServerConfiguration.configuration();
        this.bossGroup = new NioEventLoopGroup(5, (ThreadFactory)new SchedulerThreadFactory(this.getClass().getSimpleName() + "-bossEventLoop"));
        this.workerGroup = new NioEventLoopGroup(this.configuration.nioEventLoopThreadCount().intValue(), (ThreadFactory)new SchedulerThreadFactory(this.getClass().getSimpleName() + "-workerEventLoop"));
        this.scheduler = new Scheduler(this.configuration);
        this.httpState = new HttpState(this.configuration, this.scheduler);
    }

    public CompletableFuture<String> stopAsync() {
        if (!this.stopFuture.isDone() && this.stopping.compareAndSet(false, true)) {
            String message = "stopped for port" + (this.getLocalPorts().size() == 1 ? ": " + String.valueOf(this.getLocalPorts().get(0)) : "s: " + String.valueOf(this.getLocalPorts()));
            if (LOG.isInfoEnabled()) {
                LOG.info(message);
            }
            new SchedulerThreadFactory("Stop").newThread(() -> {
                List collect = this.serverChannelFutures.stream().flatMap(channelFuture -> {
                    try {
                        return Stream.of((Channel)channelFuture.get());
                    }
                    catch (Exception ex) {
                        return Stream.empty();
                    }
                }).map(ChannelOutboundInvoker::disconnect).collect(Collectors.toList());
                try {
                    for (ChannelFuture channelFuture2 : collect) {
                        channelFuture2.get();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.httpState.stop();
                this.scheduler.shutdown();
                this.bossGroup.shutdownGracefully(5L, 5L, TimeUnit.MILLISECONDS);
                this.workerGroup.shutdownGracefully(5L, 5L, TimeUnit.MILLISECONDS);
                this.bossGroup.terminationFuture().syncUninterruptibly();
                this.workerGroup.terminationFuture().syncUninterruptibly();
                this.stopFuture.complete(message);
            }).start();
        }
        return this.stopFuture;
    }

    public void stop() {
        block2: {
            try {
                this.stopAsync().get(10L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Exception while stopping", (Throwable)ex);
            }
        }
    }

    public void close() {
        this.stop();
    }

    protected EventLoopGroup getEventLoopGroup() {
        return this.workerGroup;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public boolean isRunning() {
        return !this.bossGroup.isShuttingDown() || !this.workerGroup.isShuttingDown();
    }

    public List<Integer> getLocalPorts() {
        return this.getBoundPorts(this.serverChannelFutures);
    }

    public int getLocalPort() {
        return this.getFirstBoundPort(this.serverChannelFutures);
    }

    private Integer getFirstBoundPort(List<Future<Channel>> channelFutures) {
        for (Future<Channel> channelOpened : channelFutures) {
            try {
                return ((InetSocketAddress)channelOpened.get(15L, TimeUnit.SECONDS).localAddress()).getPort();
            }
            catch (Exception ex) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Exception while retrieving port from channel future, ignoring port for this channel", (Throwable)ex);
            }
        }
        return -1;
    }

    private List<Integer> getBoundPorts(List<Future<Channel>> channelFutures) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Future<Channel> channelOpened : channelFutures) {
            try {
                ports.add(((InetSocketAddress)channelOpened.get(3L, TimeUnit.SECONDS).localAddress()).getPort());
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Exception while retrieving port from channel future, ignoring port for this channel", (Throwable)e);
            }
        }
        return ports;
    }

    public List<Integer> bindServerPorts(List<Integer> requestedPortBindings) {
        return this.bindPorts(this.serverServerBootstrap, requestedPortBindings, this.serverChannelFutures);
    }

    private List<Integer> bindPorts(ServerBootstrap serverBootstrap, List<Integer> requestedPortBindings, List<Future<Channel>> channelFutures) {
        ArrayList<Integer> actualPortBindings = new ArrayList<Integer>();
        String localBoundIP = this.configuration.localBoundIP();
        for (Integer portToBind : requestedPortBindings) {
            try {
                CompletableFuture channelOpened = new CompletableFuture();
                channelFutures.add(channelOpened);
                new SchedulerThreadFactory("MockServer thread for port: " + portToBind, false).newThread(() -> {
                    try {
                        InetSocketAddress inetSocketAddress = StringUtils.isBlank((String)localBoundIP) ? new InetSocketAddress(portToBind) : new InetSocketAddress(localBoundIP, (int)portToBind);
                        serverBootstrap.bind((SocketAddress)inetSocketAddress).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                            if (future.isSuccess()) {
                                channelOpened.complete(future.channel());
                            } else {
                                channelOpened.completeExceptionally(future.cause());
                            }
                        })).channel().closeFuture().syncUninterruptibly();
                    }
                    catch (Exception e) {
                        channelOpened.completeExceptionally(new RuntimeException("Exception while binding MockServer to port " + portToBind, e));
                    }
                }).start();
                actualPortBindings.add(((InetSocketAddress)((Channel)channelOpened.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS)).localAddress()).getPort());
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while binding MockServer to port " + portToBind, e instanceof ExecutionException ? e.getCause() : e);
            }
        }
        return actualPortBindings;
    }

    protected void startedServer(List<Integer> ports) {
        HttpState.setPort(ports);
        if (LOG.isInfoEnabled()) {
            LOG.info("started on port{}", (Object)(ports.size() == 1 ? ": " + String.valueOf(ports.get(0)) : "s: " + String.valueOf(ports)));
        }
    }

    public LifeCycle registerListener(ExpectationsListener expectationsListener) {
        this.httpState.getRequestMatchers().registerListener((RequestMatchers requestMatchers, MockServerMatcherNotifier.Cause cause) -> {
            if (cause == MockServerMatcherNotifier.Cause.API) {
                expectationsListener.updated(requestMatchers.retrieveActiveExpectations(null));
            }
        });
        return this;
    }
}

