/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.configuration;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import software.xdev.mockserver.configuration.ConfigurationProperties;
import software.xdev.mockserver.logging.MockServerLoggerConfiguration;
import software.xdev.mockserver.util.StringUtils;

public class ServerConfigurationProperties
extends ConfigurationProperties {
    private static final Logger LOG = LoggerFactory.getLogger(ServerConfigurationProperties.class);
    private static final String DEFAULT_LOG_LEVEL = "INFO";
    private static final String MOCKSERVER_LOG_LEVEL = "mockserver.logLevel";
    private static final String MOCKSERVER_DISABLE_SYSTEM_OUT = "mockserver.disableSystemOut";
    private static final String MOCKSERVER_DISABLE_LOGGING = "mockserver.disableLogging";
    private static final String MOCKSERVER_DETAILED_MATCH_FAILURES = "mockserver.detailedMatchFailures";
    private static final String MOCKSERVER_MAX_EXPECTATIONS = "mockserver.maxExpectations";
    private static final String MOCKSERVER_MAX_LOG_ENTRIES = "mockserver.maxLogEntries";
    private static final String MOCKSERVER_NIO_EVENT_LOOP_THREAD_COUNT = "mockserver.nioEventLoopThreadCount";
    private static final String MOCKSERVER_ACTION_HANDLER_THREAD_COUNT = "mockserver.actionHandlerThreadCount";
    private static final String MOCKSERVER_MATCHERS_FAIL_FAST = "mockserver.matchersFailFast";
    private static final String MOCKSERVER_ALWAYS_CLOSE_SOCKET_CONNECTIONS = "mockserver.alwaysCloseSocketConnections";
    private static final String MOCKSERVER_LOCAL_BOUND_IP = "mockserver.localBoundIP";
    private static final String MOCKSERVER_MAX_INITIAL_LINE_LENGTH = "mockserver.maxInitialLineLength";
    private static final String MOCKSERVER_MAX_HEADER_SIZE = "mockserver.maxHeaderSize";
    private static final String MOCKSERVER_MAX_CHUNK_SIZE = "mockserver.maxChunkSize";
    private static final String MOCKSERVER_USE_SEMICOLON_AS_QUERY_PARAMETER_SEPARATOR = "mockserver.useSemicolonAsQueryParameterSeparator";
    private static final String MOCKSERVER_ASSUME_ALL_REQUESTS_ARE_HTTP = "mockserver.assumeAllRequestsAreHttp";
    private static final String MOCKSERVER_ENABLE_CORS_FOR_API = "mockserver.enableCORSForAPI";
    private static final String MOCKSERVER_ENABLE_CORS_FOR_ALL_RESPONSES = "mockserver.enableCORSForAllResponses";
    private static final String MOCKSERVER_CORS_ALLOW_ORIGIN = "mockserver.corsAllowOrigin";
    private static final String MOCKSERVER_CORS_ALLOW_METHODS = "mockserver.corsAllowMethods";
    private static final String MOCKSERVER_CORS_ALLOW_HEADERS = "mockserver.corsAllowHeaders";
    private static final String MOCKSERVER_CORS_ALLOW_CREDENTIALS = "mockserver.corsAllowCredentials";
    private static final String MOCKSERVER_CORS_MAX_AGE_IN_SECONDS = "mockserver.corsMaxAgeInSeconds";
    private static final String MOCKSERVER_MAXIMUM_NUMBER_OF_REQUESTS_TO_RETURN_IN_VERIFICATION_FAILURE = "mockserver.maximumNumberOfRequestToReturnInVerificationFailure";
    private static final String MOCKSERVER_PROXY_SERVER_REALM = "mockserver.proxyAuthenticationRealm";
    private static final String MOCKSERVER_PROXY_AUTHENTICATION_USERNAME = "mockserver.proxyAuthenticationUsername";
    private static final String MOCKSERVER_PROXY_AUTHENTICATION_PASSWORD = "mockserver.proxyAuthenticationPassword";
    private static final String MOCKSERVER_NO_PROXY_HOSTS = "mockserver.noProxyHosts";
    private static final String MOCKSERVER_LIVENESS_HTTP_GET_PATH = "mockserver.livenessHttpGetPath";
    private static final String MOCKSERVER_PROPERTY_FILE = "mockserver.propertyFile";
    private static Map<String, String> slf4jOrJavaLoggerToJavaLoggerLevelMapping;
    private static Map<String, String> slf4jOrJavaLoggerToSLF4JLevelMapping;

    private static Map<String, String> getSLF4JOrJavaLoggerToJavaLoggerLevelMapping() {
        if (slf4jOrJavaLoggerToJavaLoggerLevelMapping == null) {
            slf4jOrJavaLoggerToJavaLoggerLevelMapping = Map.ofEntries(Map.entry("TRACE", "FINEST"), Map.entry("DEBUG", "FINE"), Map.entry(DEFAULT_LOG_LEVEL, DEFAULT_LOG_LEVEL), Map.entry("WARN", "WARNING"), Map.entry("ERROR", "SEVERE"), Map.entry("FINEST", "FINEST"), Map.entry("FINE", "FINE"), Map.entry("WARNING", "WARNING"), Map.entry("SEVERE", "SEVERE"), Map.entry("OFF", "OFF"));
        }
        return slf4jOrJavaLoggerToJavaLoggerLevelMapping;
    }

    private static Map<String, String> getSLF4JOrJavaLoggerToSLF4JLevelMapping() {
        if (slf4jOrJavaLoggerToSLF4JLevelMapping == null) {
            slf4jOrJavaLoggerToSLF4JLevelMapping = Map.ofEntries(Map.entry("FINEST", "TRACE"), Map.entry("FINE", "DEBUG"), Map.entry(DEFAULT_LOG_LEVEL, DEFAULT_LOG_LEVEL), Map.entry("WARNING", "WARN"), Map.entry("SEVERE", "ERROR"), Map.entry("TRACE", "TRACE"), Map.entry("DEBUG", "DEBUG"), Map.entry("WARN", "WARN"), Map.entry("ERROR", "ERROR"), Map.entry("OFF", "ERROR"));
        }
        return slf4jOrJavaLoggerToSLF4JLevelMapping;
    }

    private static String propertyFile() {
        if (StringUtils.isNotBlank((String)System.getProperty(MOCKSERVER_PROPERTY_FILE)) && "/config/mockserver.properties".equals(System.getProperty(MOCKSERVER_PROPERTY_FILE))) {
            return StringUtils.isBlank((String)System.getenv("MOCKSERVER_PROPERTY_FILE")) ? System.getProperty(MOCKSERVER_PROPERTY_FILE) : System.getenv("MOCKSERVER_PROPERTY_FILE");
        }
        return System.getProperty(MOCKSERVER_PROPERTY_FILE, StringUtils.isBlank((String)System.getenv("MOCKSERVER_PROPERTY_FILE")) ? "mockserver.properties" : System.getenv("MOCKSERVER_PROPERTY_FILE"));
    }

    public static Level logLevel() {
        String logLevel = ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_LOG_LEVEL, (String)"MOCKSERVER_LOG_LEVEL", (String)DEFAULT_LOG_LEVEL).toUpperCase();
        if (StringUtils.isBlank((String)logLevel)) {
            return Level.INFO;
        }
        if ("OFF".equals(ServerConfigurationProperties.getSLF4JOrJavaLoggerToSLF4JLevelMapping().get(logLevel))) {
            return null;
        }
        return Level.valueOf((String)ServerConfigurationProperties.getSLF4JOrJavaLoggerToSLF4JLevelMapping().get(logLevel));
    }

    public static String javaLoggerLogLevel() {
        String logLevel = ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_LOG_LEVEL, (String)"MOCKSERVER_LOG_LEVEL", (String)DEFAULT_LOG_LEVEL).toUpperCase();
        if (StringUtils.isBlank((String)logLevel)) {
            return DEFAULT_LOG_LEVEL;
        }
        if ("OFF".equals(ServerConfigurationProperties.getSLF4JOrJavaLoggerToJavaLoggerLevelMapping().get(logLevel))) {
            return "OFF";
        }
        return ServerConfigurationProperties.getSLF4JOrJavaLoggerToJavaLoggerLevelMapping().get(logLevel);
    }

    public static void logLevel(String level) {
        if (StringUtils.isNotBlank((String)level)) {
            if (!ServerConfigurationProperties.getSLF4JOrJavaLoggerToSLF4JLevelMapping().containsKey(level)) {
                throw new IllegalArgumentException("log level \"" + level + "\" is not legal it must be one of SL4J levels: \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\", or the Java Logger levels: \"FINEST\", \"FINE\", \"INFO\", \"WARNING\", \"SEVERE\", \"OFF\"");
            }
            ServerConfigurationProperties.setProperty((String)MOCKSERVER_LOG_LEVEL, (String)level);
        }
        MockServerLoggerConfiguration.configureLogger();
    }

    public static boolean disableSystemOut() {
        return Boolean.parseBoolean(ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_DISABLE_SYSTEM_OUT, (String)"MOCKSERVER_DISABLE_SYSTEM_OUT", (String)String.valueOf(false)));
    }

    public static void disableSystemOut(boolean disable) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_DISABLE_SYSTEM_OUT, (String)String.valueOf(disable));
        MockServerLoggerConfiguration.configureLogger();
    }

    public static boolean disableLogging() {
        return Boolean.parseBoolean(ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_DISABLE_LOGGING, (String)"MOCKSERVER_DISABLE_LOGGING", (String)String.valueOf(false)));
    }

    public static void disableLogging(boolean disable) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_DISABLE_LOGGING, (String)String.valueOf(disable));
        MockServerLoggerConfiguration.configureLogger();
    }

    public static boolean detailedMatchFailures() {
        return Boolean.parseBoolean(ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_DETAILED_MATCH_FAILURES, (String)"MOCKSERVER_DETAILED_MATCH_FAILURES", (String)String.valueOf(true)));
    }

    public static void detailedMatchFailures(boolean enable) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_DETAILED_MATCH_FAILURES, (String)String.valueOf(enable));
    }

    public static int maxExpectations() {
        return ServerConfigurationProperties.readIntegerProperty((String)MOCKSERVER_MAX_EXPECTATIONS, (String)"MOCKSERVER_MAX_EXPECTATIONS", (int)5000);
    }

    public static void maxExpectations(int count) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_MAX_EXPECTATIONS, (String)String.valueOf(count));
    }

    public static int maxLogEntries() {
        return ServerConfigurationProperties.readIntegerProperty((String)MOCKSERVER_MAX_LOG_ENTRIES, (String)"MOCKSERVER_MAX_LOG_ENTRIES", (int)60000);
    }

    public static void maxLogEntries(int count) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_MAX_LOG_ENTRIES, (String)String.valueOf(count));
    }

    public static int nioEventLoopThreadCount() {
        return ServerConfigurationProperties.readIntegerProperty((String)MOCKSERVER_NIO_EVENT_LOOP_THREAD_COUNT, (String)"MOCKSERVER_NIO_EVENT_LOOP_THREAD_COUNT", (int)5);
    }

    public static void nioEventLoopThreadCount(int count) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_NIO_EVENT_LOOP_THREAD_COUNT, (String)String.valueOf(count));
    }

    public static int actionHandlerThreadCount() {
        return ServerConfigurationProperties.readIntegerProperty((String)MOCKSERVER_ACTION_HANDLER_THREAD_COUNT, (String)"MOCKSERVER_ACTION_HANDLER_THREAD_COUNT", (int)Math.max(5, Runtime.getRuntime().availableProcessors()));
    }

    public static void actionHandlerThreadCount(int count) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_ACTION_HANDLER_THREAD_COUNT, (String)String.valueOf(count));
    }

    public static boolean matchersFailFast() {
        return Boolean.parseBoolean(ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_MATCHERS_FAIL_FAST, (String)"MOCKSERVER_MATCHERS_FAIL_FAST", (String)String.valueOf(true)));
    }

    public static void matchersFailFast(boolean enable) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_MATCHERS_FAIL_FAST, (String)String.valueOf(enable));
    }

    public static void alwaysCloseSocketConnections(boolean alwaysClose) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_ALWAYS_CLOSE_SOCKET_CONNECTIONS, (String)String.valueOf(alwaysClose));
    }

    public static boolean alwaysCloseSocketConnections() {
        return Boolean.parseBoolean(ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_ALWAYS_CLOSE_SOCKET_CONNECTIONS, (String)"MOCKSERVER_ALWAYS_CLOSE_SOCKET_CONNECTIONS", (String)"false"));
    }

    public static String localBoundIP() {
        return ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_LOCAL_BOUND_IP, (String)"MOCKSERVER_LOCAL_BOUND_IP", (String)"");
    }

    public static void localBoundIP(String localBoundIP) {
        if (StringUtils.isNotBlank((String)localBoundIP)) {
            ServerConfigurationProperties.setProperty((String)MOCKSERVER_LOCAL_BOUND_IP, (String)localBoundIP);
        }
    }

    public static int maxInitialLineLength() {
        return ServerConfigurationProperties.readIntegerProperty((String)MOCKSERVER_MAX_INITIAL_LINE_LENGTH, (String)"MOCKSERVER_MAX_INITIAL_LINE_LENGTH", (int)Integer.MAX_VALUE);
    }

    public static void maxInitialLineLength(int length) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_MAX_INITIAL_LINE_LENGTH, (String)String.valueOf(length));
    }

    public static int maxHeaderSize() {
        return ServerConfigurationProperties.readIntegerProperty((String)MOCKSERVER_MAX_HEADER_SIZE, (String)"MOCKSERVER_MAX_HEADER_SIZE", (int)Integer.MAX_VALUE);
    }

    public static void maxHeaderSize(int size) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_MAX_HEADER_SIZE, (String)String.valueOf(size));
    }

    public static int maxChunkSize() {
        return ServerConfigurationProperties.readIntegerProperty((String)MOCKSERVER_MAX_CHUNK_SIZE, (String)"MOCKSERVER_MAX_CHUNK_SIZE", (int)Integer.MAX_VALUE);
    }

    public static void maxChunkSize(int size) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_MAX_CHUNK_SIZE, (String)String.valueOf(size));
    }

    public static void useSemicolonAsQueryParameterSeparator(boolean useAsQueryParameterSeparator) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_USE_SEMICOLON_AS_QUERY_PARAMETER_SEPARATOR, (String)String.valueOf(useAsQueryParameterSeparator));
    }

    public static boolean useSemicolonAsQueryParameterSeparator() {
        return Boolean.parseBoolean(ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_USE_SEMICOLON_AS_QUERY_PARAMETER_SEPARATOR, (String)"MOCKSERVER_USE_SEMICOLON_AS_QUERY_PARAMETER_SEPARATOR", (String)"true"));
    }

    public static void assumeAllRequestsAreHttp(boolean assumeAllRequestsAreHttp) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_ASSUME_ALL_REQUESTS_ARE_HTTP, (String)String.valueOf(assumeAllRequestsAreHttp));
    }

    public static boolean assumeAllRequestsAreHttp() {
        return Boolean.parseBoolean(ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_ASSUME_ALL_REQUESTS_ARE_HTTP, (String)"MOCKSERVER_ASSUME_ALL_REQUESTS_ARE_HTTP", (String)"false"));
    }

    public static boolean enableCORSForAPI() {
        return Boolean.parseBoolean(ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_ENABLE_CORS_FOR_API, (String)"MOCKSERVER_ENABLE_CORS_FOR_API", (String)"false"));
    }

    public static void enableCORSForAPI(boolean enable) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_ENABLE_CORS_FOR_API, (String)String.valueOf(enable));
    }

    public static boolean enableCORSForAllResponses() {
        return Boolean.parseBoolean(ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_ENABLE_CORS_FOR_ALL_RESPONSES, (String)"MOCKSERVER_ENABLE_CORS_FOR_ALL_RESPONSES", (String)"false"));
    }

    public static void enableCORSForAllResponses(boolean enable) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_ENABLE_CORS_FOR_ALL_RESPONSES, (String)String.valueOf(enable));
    }

    public static String corsAllowOrigin() {
        return ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_CORS_ALLOW_ORIGIN, (String)"MOCKSERVER_CORS_ALLOW_ORIGIN", (String)"");
    }

    public static void corsAllowOrigin(String corsAllowOrigin) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_CORS_ALLOW_ORIGIN, (String)corsAllowOrigin);
    }

    public static String corsAllowMethods() {
        return ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_CORS_ALLOW_METHODS, (String)"MOCKSERVER_CORS_ALLOW_METHODS", (String)"");
    }

    public static void corsAllowMethods(String corsAllowMethods) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_CORS_ALLOW_METHODS, (String)corsAllowMethods);
    }

    public static String corsAllowHeaders() {
        return ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_CORS_ALLOW_HEADERS, (String)"MOCKSERVER_CORS_ALLOW_HEADERS", (String)"");
    }

    public static void corsAllowHeaders(String corsAllowHeaders) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_CORS_ALLOW_HEADERS, (String)corsAllowHeaders);
    }

    public static boolean corsAllowCredentials() {
        return Boolean.parseBoolean(ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_CORS_ALLOW_CREDENTIALS, (String)"MOCKSERVER_CORS_ALLOW_CREDENTIALS", (String)"false"));
    }

    public static void corsAllowCredentials(boolean allow) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_CORS_ALLOW_CREDENTIALS, (String)String.valueOf(allow));
    }

    public static int corsMaxAgeInSeconds() {
        return ServerConfigurationProperties.readIntegerProperty((String)MOCKSERVER_CORS_MAX_AGE_IN_SECONDS, (String)"MOCKSERVER_CORS_MAX_AGE_IN_SECONDS", (int)0);
    }

    public static void corsMaxAgeInSeconds(int ageInSeconds) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_CORS_MAX_AGE_IN_SECONDS, (String)String.valueOf(ageInSeconds));
    }

    public static Integer maximumNumberOfRequestToReturnInVerificationFailure() {
        return ServerConfigurationProperties.readIntegerProperty((String)MOCKSERVER_MAXIMUM_NUMBER_OF_REQUESTS_TO_RETURN_IN_VERIFICATION_FAILURE, (String)"MOCKSERVER_MAXIMUM_NUMBER_OF_REQUESTS_TO_RETURN_IN_VERIFICATION_FAILURE", (int)10);
    }

    public static void maximumNumberOfRequestToReturnInVerificationFailure(Integer maximumNumberOfRequestToReturnInVerification) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_MAXIMUM_NUMBER_OF_REQUESTS_TO_RETURN_IN_VERIFICATION_FAILURE, (String)String.valueOf(maximumNumberOfRequestToReturnInVerification));
    }

    public static String proxyAuthenticationRealm() {
        return ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_PROXY_SERVER_REALM, (String)"MOCKSERVER_PROXY_SERVER_REALM", (String)"MockServer HTTP Proxy");
    }

    public static void proxyAuthenticationRealm(String proxyAuthenticationRealm) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_PROXY_SERVER_REALM, (String)proxyAuthenticationRealm);
    }

    public static String proxyAuthenticationUsername() {
        return ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_PROXY_AUTHENTICATION_USERNAME, (String)"MOCKSERVER_PROXY_AUTHENTICATION_USERNAME", (String)"");
    }

    public static void proxyAuthenticationUsername(String proxyAuthenticationUsername) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_PROXY_AUTHENTICATION_USERNAME, (String)proxyAuthenticationUsername);
    }

    public static String proxyAuthenticationPassword() {
        return ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_PROXY_AUTHENTICATION_PASSWORD, (String)"MOCKSERVER_PROXY_AUTHENTICATION_PASSWORD", (String)"");
    }

    public static void noProxyHosts(String noProxyHosts) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_NO_PROXY_HOSTS, (String)noProxyHosts);
    }

    public static String noProxyHosts() {
        return ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_NO_PROXY_HOSTS, (String)"MOCKSERVER_NO_PROXY_HOSTS", (String)"");
    }

    public static void proxyAuthenticationPassword(String proxyAuthenticationPassword) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_PROXY_AUTHENTICATION_PASSWORD, (String)proxyAuthenticationPassword);
    }

    public static String livenessHttpGetPath() {
        return ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_LIVENESS_HTTP_GET_PATH, (String)"MOCKSERVER_LIVENESS_HTTP_GET_PATH", (String)"");
    }

    public static void livenessHttpGetPath(String livenessPath) {
        ServerConfigurationProperties.setProperty((String)MOCKSERVER_LIVENESS_HTTP_GET_PATH, (String)livenessPath);
    }

    private static Properties readPropertyFile() {
        Properties properties;
        block24: {
            properties = new Properties();
            try (InputStream inputStream2 = ServerConfigurationProperties.class.getClassLoader().getResourceAsStream(ServerConfigurationProperties.propertyFile());){
                if (inputStream2 != null) {
                    try {
                        properties.load(inputStream2);
                    }
                    catch (IOException e) {
                        LOG.error("Exception loading property file [{}]", (Object)ServerConfigurationProperties.propertyFile(), (Object)e);
                    }
                    break block24;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Property file not found on classpath using path [{}]", (Object)ServerConfigurationProperties.propertyFile());
                }
                try (FileInputStream fis = new FileInputStream(ServerConfigurationProperties.propertyFile());){
                    properties.load(fis);
                }
                catch (FileNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Property file not found using path [{}]", (Object)ServerConfigurationProperties.propertyFile(), (Object)e);
                    }
                }
                catch (IOException e) {
                    LOG.error("Exception loading property file [{}]", (Object)ServerConfigurationProperties.propertyFile(), (Object)e);
                }
            }
            catch (IOException inputStream2) {
                // empty catch block
            }
        }
        if (!properties.isEmpty()) {
            Enumeration<?> propertyNames = properties.propertyNames();
            StringBuilder propertiesLogDump = new StringBuilder(50);
            propertiesLogDump.append("Reading properties from property file [").append(ServerConfigurationProperties.propertyFile()).append("]:").append("\n");
            while (propertyNames.hasMoreElements()) {
                String propertyName = String.valueOf(propertyNames.nextElement());
                propertiesLogDump.append("  ").append(propertyName).append(" = ").append(properties.getProperty(propertyName)).append("\n");
            }
            Level logLevel = Level.valueOf((String)ServerConfigurationProperties.getSLF4JOrJavaLoggerToSLF4JLevelMapping().get(ServerConfigurationProperties.readPropertyHierarchically((Properties)properties, (String)MOCKSERVER_LOG_LEVEL, (String)"MOCKSERVER_LOG_LEVEL", (String)DEFAULT_LOG_LEVEL).toUpperCase()));
            if (LOG.isEnabledForLevel(logLevel)) {
                LOG.info(propertiesLogDump.toString());
            }
        }
        return properties;
    }

    static {
        properties = ServerConfigurationProperties.readPropertyFile();
    }
}

