/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import java.util.Arrays;
import java.util.List;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.Parameter;
import software.xdev.mockserver.serialization.java.MultiValueToJavaSerializer;
import software.xdev.mockserver.serialization.java.NottableStringToJavaSerializer;

public class ParameterToJavaSerializer
implements MultiValueToJavaSerializer<Parameter> {
    @Override
    public String serialize(int numberOfSpacesToIndent, Parameter parameter) {
        StringBuilder output = new StringBuilder(20);
        output.append("\n").append(" ".repeat(numberOfSpacesToIndent * 8));
        String serializedKey = NottableStringToJavaSerializer.serialize(parameter.getName(), false);
        output.append("new Parameter(").append(serializedKey);
        for (NottableString value : parameter.getValues()) {
            output.append(", ").append(NottableStringToJavaSerializer.serialize(value, serializedKey.endsWith(")")));
        }
        output.append(')');
        return output.toString();
    }

    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, List<Parameter> parameters) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            output.append(this.serialize(numberOfSpacesToIndent, parameters.get(i)));
            if (i >= parameters.size() - 1) continue;
            output.append(',');
        }
        return output.toString();
    }

    public String serializeAsJava(int numberOfSpacesToIndent, Parameter ... object) {
        return this.serializeAsJava(numberOfSpacesToIndent, Arrays.asList(object));
    }
}

