/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import org.apache.commons.text.StringEscapeUtils;
import software.xdev.mockserver.model.NottableString;

public final class NottableStringToJavaSerializer {
    public static String serialize(NottableString nottableString, boolean alwaysNottableString) {
        if (nottableString.isOptional()) {
            return "optional(\"" + StringEscapeUtils.escapeJava((String)nottableString.getValue()) + "\")";
        }
        if (nottableString.isNot()) {
            return "not(\"" + StringEscapeUtils.escapeJava((String)nottableString.getValue()) + "\")";
        }
        if (alwaysNottableString) {
            return "string(\"" + StringEscapeUtils.escapeJava((String)nottableString.getValue()) + "\")";
        }
        return "\"" + StringEscapeUtils.escapeJava((String)nottableString.getValue()) + "\"";
    }

    private NottableStringToJavaSerializer() {
    }
}

