/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.closurecallback.websocketregistry.WebSocketClientRegistry;
import software.xdev.mockserver.collections.CircularHashMap;
import software.xdev.mockserver.collections.CircularPriorityQueue;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.matchers.HttpRequestMatcher;
import software.xdev.mockserver.matchers.MatchDifference;
import software.xdev.mockserver.matchers.MatcherBuilder;
import software.xdev.mockserver.mock.Expectation;
import software.xdev.mockserver.mock.SortableExpectationId;
import software.xdev.mockserver.mock.listeners.MockServerMatcherNotifier;
import software.xdev.mockserver.model.Action;
import software.xdev.mockserver.model.ExpectationId;
import software.xdev.mockserver.model.HttpObjectCallback;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.scheduler.Scheduler;
import software.xdev.mockserver.util.StringUtils;

public class RequestMatchers
extends MockServerMatcherNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(RequestMatchers.class);
    final CircularPriorityQueue<String, HttpRequestMatcher, SortableExpectationId> httpRequestMatchers;
    final CircularHashMap<String, RequestDefinition> expectationRequestDefinitions;
    private final ServerConfiguration configuration;
    private final Scheduler scheduler;
    private final WebSocketClientRegistry webSocketClientRegistry;
    private final MatcherBuilder matcherBuilder;

    public RequestMatchers(ServerConfiguration configuration, Scheduler scheduler, WebSocketClientRegistry webSocketClientRegistry) {
        super(scheduler);
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.matcherBuilder = new MatcherBuilder(configuration);
        this.webSocketClientRegistry = webSocketClientRegistry;
        this.httpRequestMatchers = new CircularPriorityQueue<String, HttpRequestMatcher, SortableExpectationId>(configuration.maxExpectations(), SortableExpectationId.EXPECTATION_SORTABLE_PRIORITY_COMPARATOR, httpRequestMatcher -> httpRequestMatcher.getExpectation() != null ? httpRequestMatcher.getExpectation().getSortableId() : SortableExpectationId.NULL, httpRequestMatcher -> httpRequestMatcher.getExpectation() != null ? httpRequestMatcher.getExpectation().getId() : "");
        this.expectationRequestDefinitions = new CircularHashMap(configuration.maxExpectations().intValue());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Expectation circular priority queue created, with size {}", (Object)configuration.maxExpectations());
        }
    }

    public Expectation add(Expectation expectation, MockServerMatcherNotifier.Cause cause) {
        Expectation upsertedExpectation = null;
        if (expectation != null) {
            this.expectationRequestDefinitions.put((Object)expectation.getId(), (Object)expectation.getHttpRequest());
            upsertedExpectation = this.httpRequestMatchers.getByKey(expectation.getId()).map(httpRequestMatcher -> {
                if (httpRequestMatcher.getExpectation() != null) {
                    expectation.withCreated(httpRequestMatcher.getExpectation().getCreated());
                }
                this.httpRequestMatchers.removePriorityKey((HttpRequestMatcher)httpRequestMatcher);
                if (httpRequestMatcher.update(expectation)) {
                    this.httpRequestMatchers.addPriorityKey((HttpRequestMatcher)httpRequestMatcher);
                    if (LOG.isInfoEnabled()) {
                        LOG.info("updated expectation: {} with id: {}", (Object)expectation.clone(), (Object)expectation.getId());
                    }
                } else {
                    this.httpRequestMatchers.addPriorityKey((HttpRequestMatcher)httpRequestMatcher);
                }
                return httpRequestMatcher;
            }).orElseGet(() -> this.addPrioritisedExpectation(expectation, cause)).getExpectation();
            this.notifyListeners(this, cause);
        }
        return upsertedExpectation;
    }

    public void update(Expectation[] expectations, MockServerMatcherNotifier.Cause cause) {
        AtomicInteger numberOfChanges = new AtomicInteger(0);
        if (expectations != null) {
            Map<String, HttpRequestMatcher> httpRequestMatchersByKey = this.httpRequestMatchers.keyMap();
            Set<String> existingKeysForCause = httpRequestMatchersByKey.entrySet().stream().filter(entry -> ((HttpRequestMatcher)entry.getValue()).getSource().equals(cause)).map(Map.Entry::getKey).collect(Collectors.toSet());
            HashSet addedIds = new HashSet();
            Arrays.stream(expectations).forEach(expectation -> {
                if (!addedIds.contains(expectation.getId())) {
                    addedIds.add(expectation.getId());
                    this.expectationRequestDefinitions.put((Object)expectation.getId(), (Object)expectation.getHttpRequest());
                    existingKeysForCause.remove(expectation.getId());
                    if (httpRequestMatchersByKey.containsKey(expectation.getId())) {
                        HttpRequestMatcher httpRequestMatcher = (HttpRequestMatcher)httpRequestMatchersByKey.get(expectation.getId());
                        httpRequestMatcher.withSource(cause);
                        if (httpRequestMatcher.getExpectation() != null) {
                            expectation.withCreated(httpRequestMatcher.getExpectation().getCreated());
                        }
                        this.httpRequestMatchers.removePriorityKey(httpRequestMatcher);
                        if (httpRequestMatcher.update((Expectation)expectation)) {
                            this.httpRequestMatchers.addPriorityKey(httpRequestMatcher);
                            numberOfChanges.getAndIncrement();
                            if (LOG.isInfoEnabled()) {
                                LOG.info("updated expectation: {} with id: {}", (Object)expectation.clone(), (Object)expectation.getId());
                            }
                        } else {
                            this.httpRequestMatchers.addPriorityKey(httpRequestMatcher);
                        }
                    } else {
                        this.addPrioritisedExpectation((Expectation)expectation, cause);
                        numberOfChanges.getAndIncrement();
                    }
                }
            });
            existingKeysForCause.forEach(key -> {
                numberOfChanges.getAndIncrement();
                HttpRequestMatcher httpRequestMatcher = (HttpRequestMatcher)httpRequestMatchersByKey.get(key);
                this.removeHttpRequestMatcher(httpRequestMatcher, cause, false);
            });
            if (numberOfChanges.get() > 0) {
                this.notifyListeners(this, cause);
            }
        }
    }

    private HttpRequestMatcher addPrioritisedExpectation(Expectation expectation, MockServerMatcherNotifier.Cause cause) {
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(expectation);
        this.httpRequestMatchers.add(httpRequestMatcher);
        httpRequestMatcher.withSource(cause);
        if (LOG.isInfoEnabled()) {
            LOG.info("creating expectation: {} with id: {}", (Object)expectation.clone(), (Object)expectation.getId());
        }
        return httpRequestMatcher;
    }

    public int size() {
        return this.httpRequestMatchers.size();
    }

    public void reset(MockServerMatcherNotifier.Cause cause) {
        this.httpRequestMatchers.stream().forEach(httpRequestMatcher -> this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher, cause, false));
        this.expectationRequestDefinitions.clear();
        this.notifyListeners(this, cause);
    }

    public void reset() {
        this.reset(MockServerMatcherNotifier.Cause.API);
    }

    public Expectation firstMatchingExpectation(HttpRequest httpRequest) {
        Optional<Expectation> first = this.getHttpRequestMatchersCopy().map(httpRequestMatcher -> {
            Expectation matchingExpectation = null;
            boolean remainingMatchesDecremented = false;
            if (httpRequestMatcher.matches(LOG.isDebugEnabled() ? new MatchDifference(this.configuration.detailedMatchFailures(), (RequestDefinition)httpRequest) : null, (RequestDefinition)httpRequest)) {
                matchingExpectation = httpRequestMatcher.getExpectation();
                httpRequestMatcher.setResponseInProgress(true);
                if (matchingExpectation.decrementRemainingMatches()) {
                    remainingMatchesDecremented = true;
                }
            } else if (!httpRequestMatcher.isResponseInProgress() && !httpRequestMatcher.isActive()) {
                this.scheduler.submit(() -> this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher));
            }
            if (remainingMatchesDecremented) {
                this.notifyListeners(this, MockServerMatcherNotifier.Cause.API);
            }
            return matchingExpectation;
        }).filter(Objects::nonNull).findFirst();
        return first.orElse(null);
    }

    public void clear(RequestDefinition requestDefinition) {
        if (requestDefinition != null) {
            HttpRequestMatcher clearHttpRequestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
            this.getHttpRequestMatchersCopy().forEach(httpRequestMatcher -> {
                RequestDefinition request = httpRequestMatcher.getExpectation().getHttpRequest();
                if (StringUtils.isNotBlank((String)requestDefinition.getLogCorrelationId())) {
                    request = request.shallowClone().withLogCorrelationId(requestDefinition.getLogCorrelationId());
                }
                if (clearHttpRequestMatcher.matches(request)) {
                    this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher);
                }
            });
            if (LOG.isInfoEnabled()) {
                LOG.info("Cleared expectations that match: {}", (Object)requestDefinition);
            }
        } else {
            this.reset();
        }
    }

    public void clear(ExpectationId expectationId) {
        if (expectationId != null) {
            this.httpRequestMatchers.getByKey(expectationId.getId()).ifPresent(this::removeHttpRequestMatcher);
            if (LOG.isInfoEnabled()) {
                LOG.info("Cleared expectations that have id: {}", (Object)expectationId.getId());
            }
        } else {
            this.reset();
        }
    }

    Expectation postProcess(Expectation expectation) {
        if (expectation != null) {
            this.getHttpRequestMatchersCopy().filter(httpRequestMatcher -> httpRequestMatcher.getExpectation() == expectation).findFirst().ifPresent(httpRequestMatcher -> {
                if (!expectation.isActive()) {
                    this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher);
                }
                httpRequestMatcher.setResponseInProgress(false);
            });
        }
        return expectation;
    }

    private void removeHttpRequestMatcher(HttpRequestMatcher httpRequestMatcher) {
        this.removeHttpRequestMatcher(httpRequestMatcher, MockServerMatcherNotifier.Cause.API, true);
    }

    private void removeHttpRequestMatcher(HttpRequestMatcher httpRequestMatcher, MockServerMatcherNotifier.Cause cause, boolean notifyAndUpdateMetrics) {
        if (this.httpRequestMatchers.remove(httpRequestMatcher)) {
            Action action;
            if (httpRequestMatcher.getExpectation() != null && LOG.isInfoEnabled()) {
                Expectation expectation = httpRequestMatcher.getExpectation().clone();
                LOG.info("removed expectation: {} with id: {}", (Object)expectation, (Object)expectation.getId());
            }
            if (httpRequestMatcher.getExpectation() != null && (action = httpRequestMatcher.getExpectation().getAction()) instanceof HttpObjectCallback) {
                HttpObjectCallback callback = (HttpObjectCallback)action;
                this.webSocketClientRegistry.unregisterClient(callback.getClientId());
            }
            if (notifyAndUpdateMetrics) {
                this.notifyListeners(this, cause);
            }
        }
    }

    public Stream<RequestDefinition> retrieveRequestDefinitions(List<ExpectationId> expectationIds) {
        return expectationIds.stream().map(expectationId -> {
            if (StringUtils.isBlank((String)expectationId.getId())) {
                throw new IllegalArgumentException("No expectation id specified found \"" + expectationId.getId() + "\"");
            }
            if (this.expectationRequestDefinitions.containsKey((Object)expectationId.getId())) {
                return (RequestDefinition)this.expectationRequestDefinitions.get((Object)expectationId.getId());
            }
            throw new IllegalArgumentException("No expectation found with id " + expectationId.getId());
        }).filter(Objects::nonNull);
    }

    public List<Expectation> retrieveActiveExpectations(RequestDefinition requestDefinition) {
        if (requestDefinition == null) {
            return this.httpRequestMatchers.stream().map(HttpRequestMatcher::getExpectation).collect(Collectors.toList());
        }
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
        this.getHttpRequestMatchersCopy().forEach(httpRequestMatcher -> {
            if (requestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) {
                expectations.add(httpRequestMatcher.getExpectation());
            }
        });
        return expectations;
    }

    public List<HttpRequestMatcher> retrieveRequestMatchers(RequestDefinition requestDefinition) {
        if (requestDefinition == null) {
            return this.httpRequestMatchers.stream().collect(Collectors.toList());
        }
        ArrayList<HttpRequestMatcher> httpRequestMatchers = new ArrayList<HttpRequestMatcher>();
        HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
        this.getHttpRequestMatchersCopy().forEach(httpRequestMatcher -> {
            if (requestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) {
                httpRequestMatchers.add((HttpRequestMatcher)httpRequestMatcher);
            }
        });
        return httpRequestMatchers;
    }

    public boolean isEmpty() {
        return this.httpRequestMatchers.isEmpty();
    }

    @Override
    protected void notifyListeners(RequestMatchers notifier, MockServerMatcherNotifier.Cause cause) {
        super.notifyListeners(notifier, cause);
    }

    private Stream<HttpRequestMatcher> getHttpRequestMatchersCopy() {
        return this.httpRequestMatchers.stream();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestMatchers)) {
            return false;
        }
        RequestMatchers that = (RequestMatchers)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.httpRequestMatchers, that.httpRequestMatchers) && Objects.equals(this.expectationRequestDefinitions, that.expectationRequestDefinitions) && Objects.equals((Object)this.configuration, (Object)that.configuration) && Objects.equals(this.scheduler, that.scheduler) && Objects.equals(this.webSocketClientRegistry, that.webSocketClientRegistry) && Objects.equals(this.matcherBuilder, that.matcherBuilder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.httpRequestMatchers, this.expectationRequestDefinitions, this.configuration, this.scheduler, this.webSocketClientRegistry, this.matcherBuilder});
    }
}

