/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.matchers;

import java.util.Arrays;
import java.util.Objects;
import software.xdev.mockserver.logging.BinaryArrayFormatter;
import software.xdev.mockserver.matchers.BodyMatcher;
import software.xdev.mockserver.matchers.MatchDifference;

public class BinaryMatcher
extends BodyMatcher<byte[]> {
    private final byte[] matcher;

    BinaryMatcher(byte[] matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(MatchDifference context, byte[] matched) {
        boolean result = false;
        if (this.matcher == null || this.matcher.length == 0 || Arrays.equals(this.matcher, matched)) {
            result = true;
        }
        if (!result && context != null) {
            context.addDifference("binary match failed expected:{}found:{}", BinaryArrayFormatter.byteArrayToString((byte[])this.matcher), BinaryArrayFormatter.byteArrayToString((byte[])matched));
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || this.matcher.length == 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryMatcher)) {
            return false;
        }
        BinaryMatcher that = (BinaryMatcher)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.deepEquals(this.matcher, that.matcher);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.matcher));
    }
}

