/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mappers;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.codec.BodyDecoderEncoder;
import software.xdev.mockserver.codec.ExpandedParameterDecoder;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.model.Body;
import software.xdev.mockserver.model.Cookies;
import software.xdev.mockserver.model.Header;
import software.xdev.mockserver.model.Headers;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.Protocol;
import software.xdev.mockserver.url.URLParser;
import software.xdev.mockserver.util.StringUtils;

public class FullHttpRequestToMockServerHttpRequest {
    private static final Logger LOG = LoggerFactory.getLogger(FullHttpRequestToMockServerHttpRequest.class);
    private final BodyDecoderEncoder bodyDecoderEncoder = new BodyDecoderEncoder();
    private final ExpandedParameterDecoder formParameterParser;
    private final Integer port;

    public FullHttpRequestToMockServerHttpRequest(ServerConfiguration configuration, Integer port) {
        this.formParameterParser = new ExpandedParameterDecoder(configuration);
        this.port = port;
    }

    public HttpRequest mapFullHttpRequestToMockServerRequest(FullHttpRequest fullHttpRequest, List<Header> preservedHeaders, SocketAddress localAddress, SocketAddress remoteAddress) {
        HttpRequest httpRequest = new HttpRequest();
        try {
            if (fullHttpRequest != null) {
                if (fullHttpRequest.decoderResult().isFailure()) {
                    LOG.error("Exception decoding request", fullHttpRequest.decoderResult().cause());
                }
                this.setMethod(httpRequest, fullHttpRequest);
                httpRequest.withKeepAlive(Boolean.valueOf(HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest)));
                httpRequest.withProtocol(Protocol.HTTP_1_1);
                this.setPath(httpRequest, fullHttpRequest);
                this.setQueryString(httpRequest, fullHttpRequest);
                this.setHeaders(httpRequest, fullHttpRequest, preservedHeaders);
                this.setCookies(httpRequest, fullHttpRequest);
                this.setBody(httpRequest, fullHttpRequest);
                this.setSocketAddress(httpRequest, fullHttpRequest, this.port, localAddress, remoteAddress);
            }
        }
        catch (Exception ex) {
            LOG.error("Exception decoding request {}", (Object)fullHttpRequest, (Object)ex);
        }
        return httpRequest;
    }

    private void setSocketAddress(HttpRequest httpRequest, FullHttpRequest fullHttpRequest, Integer port, SocketAddress localAddress, SocketAddress remoteAddress) {
        httpRequest.withSocketAddress(fullHttpRequest.headers().get("host"), port);
        if (remoteAddress instanceof InetSocketAddress) {
            httpRequest.withRemoteAddress(StringUtils.removeStart((String)remoteAddress.toString(), (String)"/"));
        }
        if (localAddress instanceof InetSocketAddress) {
            httpRequest.withLocalAddress(StringUtils.removeStart((String)localAddress.toString(), (String)"/"));
        }
    }

    private void setMethod(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        httpRequest.withMethod(fullHttpResponse.method().name());
    }

    private void setPath(HttpRequest httpRequest, FullHttpRequest fullHttpRequest) {
        httpRequest.withPath(URLParser.returnPath((String)fullHttpRequest.uri()));
    }

    private void setQueryString(HttpRequest httpRequest, FullHttpRequest fullHttpRequest) {
        if (fullHttpRequest.uri().contains("?")) {
            httpRequest.withQueryStringParameters(this.formParameterParser.retrieveQueryParameters(fullHttpRequest.uri(), true));
        }
    }

    private void setHeaders(HttpRequest httpRequest, FullHttpRequest fullHttpResponse, List<Header> preservedHeaders) {
        HttpHeaders httpHeaders = fullHttpResponse.headers();
        if (!httpHeaders.isEmpty()) {
            Headers headers = new Headers(new Header[0]);
            for (String headerName : httpHeaders.names()) {
                headers.withEntry(headerName, httpHeaders.getAll(headerName));
            }
            httpRequest.withHeaders(headers);
        }
        if (preservedHeaders != null && !preservedHeaders.isEmpty()) {
            for (Header preservedHeader : preservedHeaders) {
                httpRequest.withHeader(preservedHeader);
            }
        }
        if (Protocol.HTTP_2.equals((Object)httpRequest.getProtocol())) {
            Integer streamId = fullHttpResponse.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            httpRequest.withStreamId(streamId);
        }
    }

    private void setCookies(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        List cookieHeaders = fullHttpResponse.headers().getAll((CharSequence)HttpHeaderNames.COOKIE);
        if (!cookieHeaders.isEmpty()) {
            Cookies cookies = new Cookies(new software.xdev.mockserver.model.Cookie[0]);
            for (String cookieHeader : cookieHeaders) {
                Set decodedCookies = ServerCookieDecoder.LAX.decode(cookieHeader);
                for (Cookie decodedCookie : decodedCookies) {
                    cookies.withEntry(decodedCookie.name(), decodedCookie.value());
                }
            }
            httpRequest.withCookies(cookies);
        }
    }

    private void setBody(HttpRequest httpRequest, FullHttpRequest fullHttpRequest) {
        httpRequest.withBody((Body)this.bodyDecoderEncoder.byteBufToBody(fullHttpRequest.content(), fullHttpRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)));
    }
}

