/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.configuration.ConfigurationProperties;
import software.xdev.mockserver.configuration.IntegerStringListParser;
import software.xdev.mockserver.configuration.ServerConfigurationProperties;
import software.xdev.mockserver.logging.MockServerLoggerConfiguration;
import software.xdev.mockserver.mock.HttpState;
import software.xdev.mockserver.netty.MockServer;
import software.xdev.mockserver.util.StringUtils;

public final class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    static final String USAGE = String.join((CharSequence)"\n", List.of("   java -jar <path to server-standalone.jar> -serverPort <port> [-proxyRemotePort <port>] [-proxyRemoteHost <hostname>] [-logLevel <level>] ", "                                                                                                                           ", "     valid options are:                                                                                                    ", "        -serverPort <port>           The HTTP, HTTPS, SOCKS and HTTP CONNECT                                               ", "                                     port(s) for both mocking and proxying                                                 ", "                                     requests.  Port unification is used to                                                ", "                                     support all protocols for proxying and                                                ", "                                     mocking on the same port(s). Supports                                                 ", "                                     comma separated list for binding to                                                   ", "                                     multiple ports.                                                                       ", "                                                                                                                           ", "        -proxyRemotePort <port>      Optionally enables port forwarding mode.                                              ", "                                     When specified all requests received will                                             ", "                                     be forwarded to the specified port, unless                                            ", "                                     they match an expectation.                                                            ", "                                                                                                                           ", "        -proxyRemoteHost <hostname>  Specified the host to forward all proxy                                               ", "                                     requests to when port forwarding mode has                                             ", "                                     been enabled using the proxyRemotePort                                                ", "                                     option.  This setting is ignored unless                                               ", "                                     proxyRemotePort has been specified. If no                                             ", "                                     value is provided for proxyRemoteHost when                                            ", "                                     proxyRemotePort has been specified,                                                   ", "                                     proxyRemoteHost will default to \"localhost\".                                        ", "                                                                                                                           ", "        -logLevel <level>            Optionally specify log level using SLF4J levels:                                      ", "                                     TRACE, DEBUG, INFO, WARN, ERROR, OFF or Java                                          ", "                                     Logger levels: FINEST, FINE, INFO, WARNING,                                           ", "                                     SEVERE or OFF. If not specified default is INFO                                       ", "                                                                                                                           ", "   i.e. java -jar ./server-standalone.jar -serverPort 1080 -proxyRemotePort 80 -proxyRemoteHost example.org -logLevel WARN", "                                                                                                                           "));
    private static final IntegerStringListParser INTEGER_STRING_LIST_PARSER = new IntegerStringListParser();
    static PrintStream systemErr = System.err;
    static PrintStream systemOut = System.out;
    static boolean usageShown;

    public static void main(String ... arguments) {
        block15: {
            try {
                Map<String, String> parsedArgs = Main.parseArguments(arguments);
                HashMap<String, String> cmdArgs = new HashMap<String, String>(parsedArgs);
                HashMap<String, String> envVarArgs = new HashMap<String, String>();
                HashMap<String, String> sysPropArgs = new HashMap<String, String>();
                System.getenv().forEach((key, value) -> {
                    if (key.startsWith("MOCKSERVER_") && StringUtils.isNotBlank((String)value)) {
                        envVarArgs.put((String)key, (String)value);
                    }
                });
                System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    if (key instanceof String) {
                        String strKey = (String)key;
                        if (value instanceof String) {
                            String strValue = (String)value;
                            if (strKey.startsWith("mockserver") && StringUtils.isNotBlank((String)strValue)) {
                                sysPropArgs.put((String)key, (String)value);
                            }
                        }
                    }
                }));
                for (Arguments parsedArgument : Arrays.asList(Arguments.serverPort, Arguments.proxyRemoteHost, Arguments.proxyRemotePort)) {
                    if (!parsedArgs.containsKey(parsedArgument.name())) {
                        if (sysPropArgs.containsKey(parsedArgument.systemPropertyName())) {
                            parsedArgs.put(parsedArgument.name(), (String)sysPropArgs.get(parsedArgument.systemPropertyName()));
                            envVarArgs.remove(parsedArgument.longEnvironmentVariableName());
                            envVarArgs.remove(parsedArgument.shortEnvironmentVariableName());
                        } else if (envVarArgs.containsKey(parsedArgument.longEnvironmentVariableName())) {
                            envVarArgs.remove(parsedArgument.shortEnvironmentVariableName());
                            parsedArgs.put(parsedArgument.name(), (String)envVarArgs.get(parsedArgument.longEnvironmentVariableName()));
                        } else if (!(!StringUtils.isNotBlank((String)System.getenv(parsedArgument.shortEnvironmentVariableName())) || parsedArgument == Arguments.serverPort && "1080".equals(System.getenv(Arguments.serverPort.shortEnvironmentVariableName())) && ConfigurationProperties.properties.containsKey(Arguments.serverPort.systemPropertyName()))) {
                            envVarArgs.put(parsedArgument.shortEnvironmentVariableName(), System.getenv(parsedArgument.shortEnvironmentVariableName()));
                            parsedArgs.put(parsedArgument.name(), (String)envVarArgs.get(parsedArgument.shortEnvironmentVariableName()));
                        }
                    } else {
                        sysPropArgs.remove(parsedArgument.systemPropertyName());
                        envVarArgs.remove(parsedArgument.longEnvironmentVariableName());
                        envVarArgs.remove(parsedArgument.shortEnvironmentVariableName());
                    }
                    if (parsedArgs.containsKey(parsedArgument.name()) || !ConfigurationProperties.properties.containsKey(parsedArgument.systemPropertyName())) continue;
                    parsedArgs.put(parsedArgument.name(), String.valueOf(ConfigurationProperties.properties.get(parsedArgument.systemPropertyName())));
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("Using environment variables: {} and system properties: {} and command line options: {}", new Object[]{Main.formatArgsForLog(envVarArgs), Main.formatArgsForLog(sysPropArgs), Main.formatArgsForLog(cmdArgs)});
                }
                if (!parsedArgs.isEmpty() && parsedArgs.containsKey(Arguments.serverPort.name())) {
                    if (parsedArgs.containsKey(Arguments.logLevel.name())) {
                        ServerConfigurationProperties.logLevel(parsedArgs.get(Arguments.logLevel.name()));
                    }
                    MockServerLoggerConfiguration.configureLogger();
                    Integer[] localPorts = INTEGER_STRING_LIST_PARSER.toArray(parsedArgs.get(Arguments.serverPort.name()));
                    MockServer mockServer = Main.launchMockServer(parsedArgs, localPorts);
                    HttpState.setPort(localPorts);
                    if (System.getProperty("exit-immediately-after-start") != null) {
                        mockServer.stop();
                    }
                } else {
                    Main.showUsage("\"" + Arguments.serverPort.name() + "\" not specified");
                }
            }
            catch (Exception ex) {
                LOG.error("Exception while starting", (Throwable)ex);
                Main.showUsage(null);
                if (!ServerConfigurationProperties.disableSystemOut()) break block15;
                new RuntimeException("exception while starting: " + ex.getMessage()).printStackTrace(System.err);
            }
        }
    }

    private static MockServer launchMockServer(Map<String, String> parsedArgs, Integer[] localPorts) {
        if (parsedArgs.containsKey(Arguments.proxyRemotePort.name())) {
            String remoteHost = parsedArgs.get(Arguments.proxyRemoteHost.name());
            if (StringUtils.isBlank((String)remoteHost)) {
                remoteHost = "localhost";
            }
            return new MockServer((Integer)Integer.parseInt(parsedArgs.get(Arguments.proxyRemotePort.name())), remoteHost, localPorts);
        }
        return new MockServer(localPorts);
    }

    static String formatArgsForLog(Map<String, String> args) {
        return "[\n\t" + args.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",\n\t")) + "\n]";
    }

    private static Map<String, String> parseArguments(String ... arguments) {
        HashMap<String, String> parsedArguments = new HashMap<String, String>();
        ArrayList<String> errorMessages = new ArrayList<String>();
        Iterator<String> argumentsIterator = Arrays.asList(arguments).iterator();
        while (argumentsIterator.hasNext()) {
            String next = argumentsIterator.next();
            String argumentName = StringUtils.substringAfter((String)next, (String)"-");
            if (!argumentsIterator.hasNext()) break;
            String argumentValue = argumentsIterator.next();
            if (!Arguments.names().containsIgnoreCase(argumentName)) {
                Main.showUsage("invalid argument \"" + argumentName + "\" found");
                break;
            }
            Object errorMessage = "";
            switch (Arguments.valueOf(argumentName)) {
                case serverPort: {
                    if (argumentValue.matches("^\\d+(,\\d+)*$")) break;
                    errorMessage = argumentName + " value \"" + argumentValue + "\" is invalid, please specify a comma separated list of ports i.e. \"1080,1081,1082\"";
                    break;
                }
                case proxyRemotePort: {
                    if (argumentValue.matches("^\\d+$")) break;
                    errorMessage = argumentName + " value \"" + argumentValue + "\" is invalid, please specify a port i.e. \"1080\"";
                    break;
                }
                case proxyRemoteHost: {
                    String validIpAddressRegex = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
                    String validHostnameRegex = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$";
                    if (argumentValue.matches("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$") || argumentValue.matches("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$")) break;
                    errorMessage = argumentName + " value \"" + argumentValue + "\" is invalid, please specify a host name i.e. \"localhost\" or \"127.0.0.1\"";
                    break;
                }
                case logLevel: {
                    if (Arrays.asList("TRACE", "DEBUG", "INFO", "WARN", "ERROR", "OFF", "FINEST", "FINE", "INFO", "WARNING", "SEVERE").contains(argumentValue)) break;
                    errorMessage = argumentName + " value \"" + argumentValue + "\" is invalid, please specify one of SL4J levels: \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\" or the Java Logger levels: \"FINEST\", \"FINE\", \"INFO\", \"WARNING\", \"SEVERE\", \"OFF\"";
                }
            }
            if (((String)errorMessage).isEmpty()) {
                parsedArguments.put(argumentName, argumentValue);
                continue;
            }
            errorMessages.add((String)errorMessage);
        }
        if (!errorMessages.isEmpty()) {
            Main.printValidationError(errorMessages);
            throw new IllegalArgumentException(((Object)errorMessages).toString());
        }
        return parsedArguments;
    }

    private static void printValidationError(List<String> errorMessages) {
        int maxLengthMessage = 0;
        for (String errorMessage : errorMessages) {
            if (errorMessage.length() <= maxLengthMessage) continue;
            maxLengthMessage = errorMessage.length();
        }
        systemOut.println("\n   " + "=".repeat(maxLengthMessage));
        for (String errorMessage : errorMessages) {
            systemOut.println("   " + errorMessage);
        }
        systemOut.println("   " + "=".repeat(maxLengthMessage) + "\n");
    }

    private static void showUsage(String errorMessage) {
        if (!usageShown) {
            usageShown = true;
            systemOut.print(USAGE);
            systemOut.flush();
        }
        if (StringUtils.isNotBlank((String)errorMessage)) {
            systemErr.print("\nERROR:  " + errorMessage + "\n\n");
            systemErr.flush();
        }
    }

    private Main() {
    }

    public static enum Arguments {
        serverPort("SERVER_PORT"),
        proxyRemoteHost("PROXY_REMOTE_HOST"),
        proxyRemotePort("PROXY_REMOTE_PORT"),
        logLevel("LOG_LEVEL");

        static final CaseInsensitiveList NAMES;
        private final String shortEnvironmentVariableName;

        private Arguments(String shortEnvironmentVariableName) {
            this.shortEnvironmentVariableName = shortEnvironmentVariableName;
        }

        public static CaseInsensitiveList names() {
            return NAMES;
        }

        public String shortEnvironmentVariableName() {
            return this.shortEnvironmentVariableName;
        }

        public String longEnvironmentVariableName() {
            return "MOCKSERVER_" + this.shortEnvironmentVariableName;
        }

        public String systemPropertyName() {
            return "mockserver." + this.name();
        }

        static {
            NAMES = new CaseInsensitiveList();
            for (Arguments arguments : Arguments.values()) {
                NAMES.add(arguments.name());
            }
        }
    }

    public static class CaseInsensitiveList
    extends ArrayList<String> {
        CaseInsensitiveList() {
        }

        boolean containsIgnoreCase(String matcher) {
            for (String listItem : this) {
                if (!listItem.equalsIgnoreCase(matcher)) continue;
                return true;
            }
            return false;
        }
    }
}

