/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.serializers.response;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import software.xdev.mockserver.model.BinaryBody;
import software.xdev.mockserver.model.BodyWithContentType;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.model.ParameterBody;
import software.xdev.mockserver.model.StringBody;

public class HttpResponseSerializer
extends StdSerializer<HttpResponse> {
    public HttpResponseSerializer() {
        super(HttpResponse.class);
    }

    public void serialize(HttpResponse httpResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        BodyWithContentType body;
        jgen.writeStartObject();
        if (httpResponse.getStatusCode() != null) {
            jgen.writeObjectField("statusCode", (Object)httpResponse.getStatusCode());
        }
        if (httpResponse.getReasonPhrase() != null) {
            jgen.writeObjectField("reasonPhrase", (Object)httpResponse.getReasonPhrase());
        }
        if (httpResponse.getHeaderList() != null && !httpResponse.getHeaderList().isEmpty()) {
            jgen.writeObjectField("headers", (Object)httpResponse.getHeaders());
        }
        if (httpResponse.getCookieList() != null && !httpResponse.getCookieList().isEmpty()) {
            jgen.writeObjectField("cookies", (Object)httpResponse.getCookies());
        }
        if ((body = httpResponse.getBody()) != null) {
            ParameterBody parameterBody;
            BinaryBody binaryBody;
            StringBody stringBody;
            if (body instanceof StringBody && !(stringBody = (StringBody)body).getValue().isEmpty()) {
                jgen.writeObjectField("body", (Object)body);
            } else if (body instanceof BinaryBody && (binaryBody = (BinaryBody)body).getValue().length > 0) {
                jgen.writeObjectField("body", (Object)body);
            } else if (body instanceof ParameterBody && !(parameterBody = (ParameterBody)((Object)body)).getValue().isEmpty()) {
                jgen.writeObjectField("body", (Object)body);
            }
        }
        if (httpResponse.getDelay() != null) {
            jgen.writeObjectField("delay", (Object)httpResponse.getDelay());
        }
        if (httpResponse.getConnectionOptions() != null) {
            jgen.writeObjectField("connectionOptions", (Object)httpResponse.getConnectionOptions());
        }
        jgen.writeEndObject();
    }
}

