/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import software.xdev.mockserver.matchers.TimeToLive;
import software.xdev.mockserver.serialization.model.DTO;

public class TimeToLiveDTO
implements DTO<TimeToLive> {
    private TimeUnit timeUnit;
    private Long timeToLive;
    private Long endDate;
    private boolean unlimited;

    public TimeToLiveDTO(TimeToLive timeToLive) {
        this.timeUnit = timeToLive.getTimeUnit();
        this.timeToLive = timeToLive.getTimeToLive();
        this.endDate = timeToLive.getEndDate();
        this.unlimited = timeToLive.isUnlimited();
    }

    public TimeToLiveDTO() {
    }

    @Override
    public TimeToLive buildObject() {
        if (this.unlimited) {
            return TimeToLive.unlimited();
        }
        TimeToLive exactly = TimeToLive.exactly(this.timeUnit, this.timeToLive);
        if (this.endDate != null) {
            exactly.setEndDate(this.endDate);
        }
        return exactly;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Long getTimeToLive() {
        return this.timeToLive;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeToLiveDTO)) {
            return false;
        }
        TimeToLiveDTO that = (TimeToLiveDTO)o;
        return this.isUnlimited() == that.isUnlimited() && this.getTimeUnit() == that.getTimeUnit() && Objects.equals(this.getTimeToLive(), that.getTimeToLive());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTimeUnit(), this.getTimeToLive(), this.isUnlimited()});
    }
}

