/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import software.xdev.mockserver.model.Body;
import software.xdev.mockserver.model.Cookies;
import software.xdev.mockserver.model.Headers;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.Not;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.Parameters;
import software.xdev.mockserver.model.Protocol;
import software.xdev.mockserver.model.SocketAddress;
import software.xdev.mockserver.serialization.model.BodyDTO;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.RequestDefinitionDTO;

public class HttpRequestDTO
extends RequestDefinitionDTO
implements DTO<HttpRequest> {
    private NottableString method = NottableString.string("");
    private NottableString path = NottableString.string("");
    private Parameters pathParameters;
    private Parameters queryStringParameters;
    private BodyDTO body;
    private Cookies cookies;
    private Headers headers;
    private Boolean keepAlive;
    private Protocol protocol;
    private SocketAddress socketAddress;
    private String localAddress;
    private String remoteAddress;

    public HttpRequestDTO() {
        super(null);
    }

    public HttpRequestDTO(HttpRequest httpRequest) {
        super(httpRequest != null ? httpRequest.getNot() : null);
        if (httpRequest != null) {
            this.method = httpRequest.getMethod();
            this.path = httpRequest.getPath();
            this.headers = httpRequest.getHeaders();
            this.cookies = httpRequest.getCookies();
            this.pathParameters = httpRequest.getPathParameters();
            this.queryStringParameters = httpRequest.getQueryStringParameters();
            this.body = BodyDTO.createDTO(httpRequest.getBody());
            this.keepAlive = httpRequest.isKeepAlive();
            this.protocol = httpRequest.getProtocol();
            this.socketAddress = httpRequest.getSocketAddress();
            this.localAddress = httpRequest.getLocalAddress();
            this.remoteAddress = httpRequest.getRemoteAddress();
        }
    }

    @Override
    public HttpRequest buildObject() {
        return (HttpRequest)new HttpRequest().withMethod(this.method).withPath(this.path).withPathParameters(this.pathParameters).withQueryStringParameters(this.queryStringParameters).withBody(this.body != null ? (Body)Not.not(this.body.buildObject(), this.body.getNot()) : null).withHeaders(this.headers).withCookies(this.cookies).withProtocol(this.protocol).withKeepAlive(this.keepAlive).withSocketAddress(this.socketAddress).withLocalAddress(this.localAddress).withRemoteAddress(this.remoteAddress).withNot(this.getNot());
    }

    public NottableString getMethod() {
        return this.method;
    }

    public HttpRequestDTO setMethod(NottableString method) {
        this.method = method;
        return this;
    }

    public NottableString getPath() {
        return this.path;
    }

    public HttpRequestDTO setPath(NottableString path) {
        this.path = path;
        return this;
    }

    public Parameters getPathParameters() {
        return this.pathParameters;
    }

    public HttpRequestDTO setPathParameters(Parameters pathParameters) {
        this.pathParameters = pathParameters;
        return this;
    }

    public Parameters getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public HttpRequestDTO setQueryStringParameters(Parameters queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
        return this;
    }

    public BodyDTO getBody() {
        return this.body;
    }

    public HttpRequestDTO setBody(BodyDTO body) {
        this.body = body;
        return this;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public HttpRequestDTO setHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public HttpRequestDTO setCookies(Cookies cookies) {
        this.cookies = cookies;
        return this;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public HttpRequestDTO setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public HttpRequestDTO setProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public HttpRequestDTO setSocketAddress(SocketAddress socketAddress) {
        this.socketAddress = socketAddress;
        return this;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public HttpRequestDTO setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public HttpRequestDTO setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }
}

