/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import software.xdev.mockserver.model.Delay;
import software.xdev.mockserver.model.HttpObjectCallback;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.DelayDTO;

public class HttpObjectCallbackDTO
implements DTO<HttpObjectCallback> {
    private String clientId;
    private Boolean responseCallback;
    private DelayDTO delay;

    public HttpObjectCallbackDTO(HttpObjectCallback httpObjectCallback) {
        if (httpObjectCallback != null) {
            this.clientId = httpObjectCallback.getClientId();
            this.responseCallback = httpObjectCallback.getResponseCallback();
            if (httpObjectCallback.getDelay() != null) {
                this.delay = new DelayDTO(httpObjectCallback.getDelay());
            }
        }
    }

    public HttpObjectCallbackDTO() {
    }

    @Override
    public HttpObjectCallback buildObject() {
        Delay delay = null;
        if (this.delay != null) {
            delay = this.delay.buildObject();
        }
        return (HttpObjectCallback)new HttpObjectCallback().withClientId(this.clientId).withResponseCallback(this.responseCallback).withDelay(delay);
    }

    public String getClientId() {
        return this.clientId;
    }

    public HttpObjectCallbackDTO setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public Boolean getResponseCallback() {
        return this.responseCallback;
    }

    public HttpObjectCallbackDTO setResponseCallback(Boolean responseCallback) {
        this.responseCallback = responseCallback;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public void setDelay(DelayDTO delay) {
        this.delay = delay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpObjectCallbackDTO)) {
            return false;
        }
        HttpObjectCallbackDTO that = (HttpObjectCallbackDTO)o;
        return Objects.equals(this.getClientId(), that.getClientId()) && Objects.equals(this.getResponseCallback(), that.getResponseCallback()) && Objects.equals(this.getDelay(), that.getDelay());
    }

    public int hashCode() {
        return Objects.hash(this.getClientId(), this.getResponseCallback(), this.getDelay());
    }
}

