/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import software.xdev.mockserver.matchers.TimeToLive;
import software.xdev.mockserver.matchers.Times;
import software.xdev.mockserver.mock.Expectation;
import software.xdev.mockserver.model.HttpClassCallback;
import software.xdev.mockserver.model.HttpError;
import software.xdev.mockserver.model.HttpForward;
import software.xdev.mockserver.model.HttpObjectCallback;
import software.xdev.mockserver.model.HttpOverrideForwardedRequest;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.HttpClassCallbackDTO;
import software.xdev.mockserver.serialization.model.HttpErrorDTO;
import software.xdev.mockserver.serialization.model.HttpForwardDTO;
import software.xdev.mockserver.serialization.model.HttpObjectCallbackDTO;
import software.xdev.mockserver.serialization.model.HttpOverrideForwardedRequestDTO;
import software.xdev.mockserver.serialization.model.HttpRequestDTO;
import software.xdev.mockserver.serialization.model.HttpResponseDTO;
import software.xdev.mockserver.serialization.model.RequestDefinitionDTO;
import software.xdev.mockserver.serialization.model.TimeToLiveDTO;
import software.xdev.mockserver.serialization.model.TimesDTO;

public class ExpectationDTO
extends ObjectWithJsonToString
implements DTO<Expectation> {
    private String id;
    private Integer priority;
    private RequestDefinitionDTO httpRequest;
    private HttpResponseDTO httpResponse;
    private HttpClassCallbackDTO httpResponseClassCallback;
    private HttpObjectCallbackDTO httpResponseObjectCallback;
    private HttpForwardDTO httpForward;
    private HttpClassCallbackDTO httpForwardClassCallback;
    private HttpObjectCallbackDTO httpForwardObjectCallback;
    private HttpOverrideForwardedRequestDTO httpOverrideForwardedRequest;
    private HttpErrorDTO httpError;
    private TimesDTO times;
    private TimeToLiveDTO timeToLive;

    public ExpectationDTO(Expectation expectation) {
        if (expectation != null) {
            TimeToLive timeToLive;
            Times times;
            HttpError httpError;
            HttpOverrideForwardedRequest httpOverrideForwardedRequest;
            HttpObjectCallback httpForwardObjectCallback;
            HttpClassCallback httpForwardClassCallback;
            HttpForward httpForward;
            HttpObjectCallback httpResponseObjectCallback;
            HttpClassCallback httpResponseClassCallback;
            HttpResponse httpResponse;
            RequestDefinition requestMatcher;
            this.id = expectation.getId();
            Integer priority = expectation.getPriority();
            if (priority != null) {
                this.priority = expectation.getPriority();
            }
            if ((requestMatcher = expectation.getHttpRequest()) instanceof HttpRequest) {
                this.httpRequest = new HttpRequestDTO((HttpRequest)requestMatcher);
            }
            if ((httpResponse = expectation.getHttpResponse()) != null) {
                this.httpResponse = new HttpResponseDTO(httpResponse);
            }
            if ((httpResponseClassCallback = expectation.getHttpResponseClassCallback()) != null) {
                this.httpResponseClassCallback = new HttpClassCallbackDTO(httpResponseClassCallback);
            }
            if ((httpResponseObjectCallback = expectation.getHttpResponseObjectCallback()) != null) {
                this.httpResponseObjectCallback = new HttpObjectCallbackDTO(httpResponseObjectCallback);
            }
            if ((httpForward = expectation.getHttpForward()) != null) {
                this.httpForward = new HttpForwardDTO(httpForward);
            }
            if ((httpForwardClassCallback = expectation.getHttpForwardClassCallback()) != null) {
                this.httpForwardClassCallback = new HttpClassCallbackDTO(httpForwardClassCallback);
            }
            if ((httpForwardObjectCallback = expectation.getHttpForwardObjectCallback()) != null) {
                this.httpForwardObjectCallback = new HttpObjectCallbackDTO(httpForwardObjectCallback);
            }
            if ((httpOverrideForwardedRequest = expectation.getHttpOverrideForwardedRequest()) != null) {
                this.httpOverrideForwardedRequest = new HttpOverrideForwardedRequestDTO(httpOverrideForwardedRequest);
            }
            if ((httpError = expectation.getHttpError()) != null) {
                this.httpError = new HttpErrorDTO(httpError);
            }
            if ((times = expectation.getTimes()) != null) {
                this.times = new TimesDTO(times);
            }
            if ((timeToLive = expectation.getTimeToLive()) != null) {
                this.timeToLive = new TimeToLiveDTO(timeToLive);
            }
        }
    }

    public ExpectationDTO() {
    }

    @Override
    public Expectation buildObject() {
        RequestDefinition httpRequest = null;
        HttpResponse httpResponse = null;
        HttpClassCallback httpResponseClassCallback = null;
        HttpObjectCallback httpResponseObjectCallback = null;
        HttpForward httpForward = null;
        HttpClassCallback httpForwardClassCallback = null;
        HttpObjectCallback httpForwardObjectCallback = null;
        HttpOverrideForwardedRequest httpOverrideForwardedRequest = null;
        HttpError httpError = null;
        if (this.httpRequest != null) {
            httpRequest = this.httpRequest.buildObject();
        }
        if (this.httpResponse != null) {
            httpResponse = this.httpResponse.buildObject();
        }
        if (this.httpResponseClassCallback != null) {
            httpResponseClassCallback = this.httpResponseClassCallback.buildObject();
        }
        if (this.httpResponseObjectCallback != null) {
            httpResponseObjectCallback = this.httpResponseObjectCallback.buildObject();
        }
        if (this.httpForward != null) {
            httpForward = this.httpForward.buildObject();
        }
        if (this.httpForwardClassCallback != null) {
            httpForwardClassCallback = this.httpForwardClassCallback.buildObject();
        }
        if (this.httpForwardObjectCallback != null) {
            httpForwardObjectCallback = this.httpForwardObjectCallback.buildObject();
        }
        if (this.httpOverrideForwardedRequest != null) {
            httpOverrideForwardedRequest = this.httpOverrideForwardedRequest.buildObject();
        }
        if (this.httpError != null) {
            httpError = this.httpError.buildObject();
        }
        Times times = this.times != null ? this.times.buildObject() : Times.unlimited();
        TimeToLive timeToLive = this.timeToLive != null ? this.timeToLive.buildObject() : TimeToLive.unlimited();
        int priority = this.priority != null ? this.priority : 0;
        return new Expectation(httpRequest, times, timeToLive, priority).withId(this.id).thenRespond(httpResponse).thenRespond(httpResponseClassCallback).thenRespond(httpResponseObjectCallback).thenForward(httpForward).thenForward(httpForwardClassCallback).thenForward(httpForwardObjectCallback).thenForward(httpOverrideForwardedRequest).thenError(httpError);
    }

    public String getId() {
        return this.id;
    }

    public ExpectationDTO setId(String id) {
        this.id = id;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public ExpectationDTO setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public RequestDefinitionDTO getHttpRequest() {
        return this.httpRequest;
    }

    public ExpectationDTO setHttpRequest(RequestDefinitionDTO httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public HttpResponseDTO getHttpResponse() {
        return this.httpResponse;
    }

    public ExpectationDTO setHttpResponse(HttpResponseDTO httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpClassCallbackDTO getHttpResponseClassCallback() {
        return this.httpResponseClassCallback;
    }

    public ExpectationDTO setHttpResponseClassCallback(HttpClassCallbackDTO httpObjectCallback) {
        this.httpResponseClassCallback = httpObjectCallback;
        return this;
    }

    public HttpObjectCallbackDTO getHttpResponseObjectCallback() {
        return this.httpResponseObjectCallback;
    }

    public ExpectationDTO setHttpResponseObjectCallback(HttpObjectCallbackDTO httpObjectCallback) {
        this.httpResponseObjectCallback = httpObjectCallback;
        return this;
    }

    public HttpForwardDTO getHttpForward() {
        return this.httpForward;
    }

    public ExpectationDTO setHttpForward(HttpForwardDTO httpForward) {
        this.httpForward = httpForward;
        return this;
    }

    public HttpClassCallbackDTO getHttpForwardClassCallback() {
        return this.httpForwardClassCallback;
    }

    public ExpectationDTO setHttpForwardClassCallback(HttpClassCallbackDTO httpClassCallback) {
        this.httpForwardClassCallback = httpClassCallback;
        return this;
    }

    public HttpObjectCallbackDTO getHttpForwardObjectCallback() {
        return this.httpForwardObjectCallback;
    }

    public ExpectationDTO setHttpForwardObjectCallback(HttpObjectCallbackDTO httpObjectCallback) {
        this.httpForwardObjectCallback = httpObjectCallback;
        return this;
    }

    public HttpOverrideForwardedRequestDTO getHttpOverrideForwardedRequest() {
        return this.httpOverrideForwardedRequest;
    }

    public ExpectationDTO setHttpOverrideForwardedRequest(HttpOverrideForwardedRequestDTO httpOverrideForwardedRequest) {
        this.httpOverrideForwardedRequest = httpOverrideForwardedRequest;
        return this;
    }

    public HttpErrorDTO getHttpError() {
        return this.httpError;
    }

    public ExpectationDTO setHttpError(HttpErrorDTO httpError) {
        this.httpError = httpError;
        return this;
    }

    public TimesDTO getTimes() {
        return this.times;
    }

    public ExpectationDTO setTimes(TimesDTO times) {
        this.times = times;
        return this;
    }

    public TimeToLiveDTO getTimeToLive() {
        return this.timeToLive;
    }

    public ExpectationDTO setTimeToLive(TimeToLiveDTO timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpectationDTO)) {
            return false;
        }
        ExpectationDTO that = (ExpectationDTO)o;
        return Objects.equals(this.getPriority(), that.getPriority()) && Objects.equals(this.getHttpRequest(), that.getHttpRequest()) && Objects.equals(this.getHttpResponse(), that.getHttpResponse()) && Objects.equals(this.getHttpResponseClassCallback(), that.getHttpResponseClassCallback()) && Objects.equals(this.getHttpResponseObjectCallback(), that.getHttpResponseObjectCallback()) && Objects.equals(this.getHttpForward(), that.getHttpForward()) && Objects.equals(this.getHttpForwardClassCallback(), that.getHttpForwardClassCallback()) && Objects.equals(this.getHttpForwardObjectCallback(), that.getHttpForwardObjectCallback()) && Objects.equals(this.getHttpOverrideForwardedRequest(), that.getHttpOverrideForwardedRequest()) && Objects.equals(this.getHttpError(), that.getHttpError()) && Objects.equals(this.getTimes(), that.getTimes()) && Objects.equals(this.getTimeToLive(), that.getTimeToLive());
    }

    public int hashCode() {
        return Objects.hash(this.getPriority(), this.getHttpRequest(), this.getHttpResponse(), this.getHttpResponseClassCallback(), this.getHttpResponseObjectCallback(), this.getHttpForward(), this.getHttpForwardClassCallback(), this.getHttpForwardObjectCallback(), this.getHttpOverrideForwardedRequest(), this.getHttpError(), this.getTimes(), this.getTimeToLive());
    }
}

