/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Arrays;
import java.util.Objects;
import software.xdev.mockserver.model.BinaryBody;
import software.xdev.mockserver.serialization.model.BodyWithContentTypeDTO;

public class BinaryBodyDTO
extends BodyWithContentTypeDTO {
    private final byte[] base64Bytes;

    public BinaryBodyDTO(BinaryBody binaryBody) {
        this(binaryBody, null);
    }

    public BinaryBodyDTO(BinaryBody binaryBody, Boolean not) {
        super(binaryBody.getType(), not, binaryBody);
        this.base64Bytes = binaryBody.getRawBytes() != null ? binaryBody.getRawBytes() : new byte[]{};
    }

    public byte[] getBase64Bytes() {
        return this.base64Bytes;
    }

    @Override
    public BinaryBody buildObject() {
        return (BinaryBody)new BinaryBody(this.getBase64Bytes(), this.getMediaType()).withOptional(this.getOptional());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryBodyDTO)) {
            return false;
        }
        BinaryBodyDTO that = (BinaryBodyDTO)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.deepEquals(this.getBase64Bytes(), that.getBase64Bytes());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.getBase64Bytes()));
    }
}

