/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.deserializers.body;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.model.BinaryBody;
import software.xdev.mockserver.model.Body;
import software.xdev.mockserver.model.MediaType;
import software.xdev.mockserver.model.StringBody;
import software.xdev.mockserver.serialization.model.BinaryBodyDTO;
import software.xdev.mockserver.serialization.model.BodyDTO;
import software.xdev.mockserver.serialization.model.BodyWithContentTypeDTO;
import software.xdev.mockserver.serialization.model.StringBodyDTO;
import software.xdev.mockserver.util.StringUtils;

public class BodyWithContentTypeDTODeserializer
extends StdDeserializer<BodyWithContentTypeDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(BodyWithContentTypeDTODeserializer.class);
    private static final Map<String, Body.Type> FIELD_NAME_TO_TYPE = new HashMap<String, Body.Type>(Map.ofEntries(Map.entry("base64bytes", Body.Type.BINARY), Map.entry("string", Body.Type.STRING)));
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();

    public BodyWithContentTypeDTODeserializer() {
        super(BodyWithContentTypeDTO.class);
    }

    public BodyWithContentTypeDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        BodyDTO result = null;
        JsonToken currentToken = jsonParser.getCurrentToken();
        String valueJsonValue = "";
        byte[] rawBytes = null;
        Enum type = null;
        Boolean not = null;
        Boolean optional = null;
        MediaType contentType = null;
        Charset charset = null;
        if (currentToken == JsonToken.START_OBJECT) {
            Map body = (Map)ctxt.readValue(jsonParser, Map.class);
            for (Map.Entry entry : body.entrySet()) {
                String key;
                block32: {
                    block31: {
                        Object v;
                        block30: {
                            Object k = entry.getKey();
                            if (!(k instanceof String)) continue;
                            key = (String)k;
                            if ("type".equalsIgnoreCase(key)) {
                                try {
                                    type = Body.Type.valueOf(String.valueOf(entry.getValue()));
                                }
                                catch (IllegalArgumentException iae) {
                                    if (!LOG.isTraceEnabled()) break block30;
                                    LOG.trace("Ignoring invalid value for \"type\" field of \"{}\"", entry.getValue(), (Object)iae);
                                }
                            }
                        }
                        if (this.containsIgnoreCase(key, "string", "regex", "base64Bytes") && type != Body.Type.PARAMETERS) {
                            String fieldName = String.valueOf(entry.getKey()).toLowerCase();
                            if (FIELD_NAME_TO_TYPE.containsKey(fieldName)) {
                                type = FIELD_NAME_TO_TYPE.get(fieldName);
                            }
                            valueJsonValue = String.valueOf(entry.getValue());
                        }
                        if (this.containsIgnoreCase(key, "rawBytes", "base64Bytes") && (v = entry.getValue()) instanceof String) {
                            String s = (String)v;
                            try {
                                rawBytes = BASE64_DECODER.decode(s);
                            }
                            catch (Exception ex) {
                                if (!LOG.isDebugEnabled()) break block31;
                                LOG.debug("Invalid base64 encoded rawBytes with value \"{}\"", entry.getValue(), (Object)ex);
                            }
                        }
                    }
                    if ("not".equalsIgnoreCase(key)) {
                        not = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                    }
                    if ("optional".equalsIgnoreCase(key)) {
                        optional = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                    }
                    if ("contentType".equalsIgnoreCase(key)) {
                        try {
                            MediaType parsedMediaTypeHeader;
                            String mediaTypeHeader = String.valueOf(entry.getValue());
                            if (StringUtils.isNotBlank(mediaTypeHeader) && StringUtils.isNotBlank((parsedMediaTypeHeader = MediaType.parse(mediaTypeHeader)).toString())) {
                                contentType = parsedMediaTypeHeader;
                            }
                        }
                        catch (IllegalArgumentException uce) {
                            if (!LOG.isDebugEnabled()) break block32;
                            LOG.debug("Ignoring unsupported MediaType with value \"{}\"", entry.getValue(), (Object)uce);
                        }
                    }
                }
                if (!"charset".equalsIgnoreCase(key)) continue;
                try {
                    charset = Charset.forName(String.valueOf(entry.getValue()));
                }
                catch (UnsupportedCharsetException uce) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Ignoring unsupported Charset with value \"{}\"", entry.getValue(), (Object)uce);
                }
                catch (IllegalCharsetNameException icne) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Ignoring invalid Charset with value \"{}\"", entry.getValue(), (Object)icne);
                }
            }
            if (type != null) {
                switch (1.$SwitchMap$software$xdev$mockserver$model$Body$Type[type.ordinal()]) {
                    case 1: {
                        if (contentType != null && StringUtils.isNotBlank(contentType.toString())) {
                            result = new BinaryBodyDTO(new BinaryBody(rawBytes, contentType), not);
                            break;
                        }
                        result = new BinaryBodyDTO(new BinaryBody(rawBytes), not);
                        break;
                    }
                    case 2: {
                        if (contentType != null && StringUtils.isNotBlank(contentType.toString())) {
                            result = new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, false, contentType), not);
                            break;
                        }
                        if (charset != null) {
                            result = new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, false, StringBody.DEFAULT_CONTENT_TYPE.withCharset(charset)), not);
                            break;
                        }
                        result = new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, false, null), not);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        } else if (currentToken == JsonToken.VALUE_STRING) {
            result = new StringBodyDTO(new StringBody(jsonParser.getText()));
        }
        if (result != null) {
            result.withOptional(optional);
        }
        return result;
    }

    private boolean containsIgnoreCase(String valueToMatch, String ... listOfValues) {
        for (String item : listOfValues) {
            if (!item.equalsIgnoreCase(valueToMatch)) continue;
            return true;
        }
        return false;
    }
}

