/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.serialization.JsonArraySerializer;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.serialization.Serializer;
import software.xdev.mockserver.serialization.model.HttpRequestDTO;
import software.xdev.mockserver.serialization.model.HttpRequestPrettyPrintedDTO;
import software.xdev.mockserver.serialization.model.RequestDefinitionDTO;
import software.xdev.mockserver.util.StringUtils;

public class RequestDefinitionSerializer
implements Serializer<RequestDefinition> {
    private final ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]);
    private final ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private final JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();

    @Override
    public String serialize(RequestDefinition requestDefinition) {
        return this.serialize(false, requestDefinition);
    }

    public String serialize(boolean prettyPrint, RequestDefinition requestDefinition) {
        try {
            if (requestDefinition instanceof HttpRequest) {
                HttpRequest request = (HttpRequest)requestDefinition;
                return this.objectWriter.writeValueAsString((Object)(prettyPrint ? new HttpRequestPrettyPrintedDTO(request) : new HttpRequestDTO(request)));
            }
            return "";
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while serializing RequestDefinition to JSON with value " + String.valueOf(requestDefinition), e);
        }
    }

    @Override
    public String serialize(List<? extends RequestDefinition> requestDefinitions) {
        return this.serialize(false, requestDefinitions);
    }

    public String serialize(boolean prettyPrint, List<? extends RequestDefinition> requestDefinitions) {
        return this.serialize(prettyPrint, requestDefinitions.toArray(new RequestDefinition[0]));
    }

    @Override
    public String serialize(RequestDefinition ... requestDefinitions) {
        return this.serialize(false, requestDefinitions);
    }

    public String serialize(boolean prettyPrint, RequestDefinition ... requestDefinitions) {
        try {
            if (requestDefinitions != null && requestDefinitions.length > 0) {
                Object[] requestDefinitionDTOs = new Object[requestDefinitions.length];
                for (int i = 0; i < requestDefinitions.length; ++i) {
                    RequestDefinition requestDefinition = requestDefinitions[i];
                    if (!(requestDefinition instanceof HttpRequest)) continue;
                    HttpRequest request = (HttpRequest)requestDefinition;
                    requestDefinitionDTOs[i] = prettyPrint ? new HttpRequestPrettyPrintedDTO(request) : new HttpRequestDTO(request);
                }
                return this.objectWriter.writeValueAsString((Object)requestDefinitionDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while serializing RequestDefinition to JSON with value " + String.valueOf(Arrays.asList(requestDefinitions)), e);
        }
    }

    @Override
    public RequestDefinition deserialize(String jsonRequestDefinition) {
        try {
            JsonNode jsonNode;
            if (jsonRequestDefinition.contains("\"httpRequest\"")) {
                jsonNode = this.objectMapper.readTree(jsonRequestDefinition);
                if (jsonNode.has("httpRequest")) {
                    jsonRequestDefinition = jsonNode.get("httpRequest").toString();
                }
            } else if (jsonRequestDefinition.contains("\"openAPIDefinition\"") && (jsonNode = this.objectMapper.readTree(jsonRequestDefinition)).has("openAPIDefinition")) {
                jsonRequestDefinition = jsonNode.get("openAPIDefinition").toString();
            }
            RequestDefinitionDTO requestDefinitionDTO = (RequestDefinitionDTO)this.objectMapper.readValue(jsonRequestDefinition, RequestDefinitionDTO.class);
            if (requestDefinitionDTO != null) {
                return requestDefinitionDTO.buildObject();
            }
            return null;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("exception while parsing [" + jsonRequestDefinition + "] for RequestDefinition", ex);
        }
    }

    @Override
    public Class<RequestDefinition> supportsType() {
        return RequestDefinition.class;
    }

    public RequestDefinition[] deserializeArray(String jsonRequestDefinitions) {
        ArrayList<RequestDefinition> requestDefinitions = new ArrayList<RequestDefinition>();
        if (StringUtils.isBlank(jsonRequestDefinitions)) {
            throw new IllegalArgumentException("1 error:\n - a request or request array is required but value was \"" + jsonRequestDefinitions + "\"");
        }
        List<String> jsonRequestList = this.jsonArraySerializer.splitJSONArray(jsonRequestDefinitions);
        if (jsonRequestList.isEmpty()) {
            throw new IllegalArgumentException("1 error:\n - a request or array of request is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonRequest : jsonRequestList) {
            try {
                requestDefinitions.add(this.deserialize(jsonRequest));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + String.join((CharSequence)",\n", validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return requestDefinitions.toArray(new RequestDefinition[0]);
    }
}

