/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.mockserver.model.HttpRequestAndHttpResponse;
import software.xdev.mockserver.serialization.JsonArraySerializer;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.serialization.Serializer;
import software.xdev.mockserver.serialization.model.HttpRequestAndHttpResponseDTO;
import software.xdev.mockserver.util.StringUtils;

public class HttpRequestAndHttpResponseSerializer
implements Serializer<HttpRequestAndHttpResponse> {
    private final ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]);
    private final ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private final JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();

    @Override
    public String serialize(HttpRequestAndHttpResponse httpRequestAndHttpResponse) {
        try {
            return this.objectWriter.writeValueAsString((Object)new HttpRequestAndHttpResponseDTO(httpRequestAndHttpResponse));
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while serializing HttpRequestAndHttpResponse to JSON with value " + String.valueOf(httpRequestAndHttpResponse), e);
        }
    }

    @Override
    public String serialize(List<HttpRequestAndHttpResponse> httpRequests) {
        return this.serialize(httpRequests.toArray(new HttpRequestAndHttpResponse[0]));
    }

    @Override
    public String serialize(HttpRequestAndHttpResponse ... httpRequests) {
        try {
            if (httpRequests != null && httpRequests.length > 0) {
                HttpRequestAndHttpResponseDTO[] httpRequestDTOs = new HttpRequestAndHttpResponseDTO[httpRequests.length];
                for (int i = 0; i < httpRequests.length; ++i) {
                    httpRequestDTOs[i] = new HttpRequestAndHttpResponseDTO(httpRequests[i]);
                }
                return this.objectWriter.writeValueAsString((Object)httpRequestDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while serializing HttpRequestAndHttpResponse to JSON with value " + String.valueOf(Arrays.asList(httpRequests)), e);
        }
    }

    @Override
    public HttpRequestAndHttpResponse deserialize(String jsonHttpRequest) {
        if (jsonHttpRequest.contains("\"httpRequestAndHttpResponse\"")) {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(jsonHttpRequest);
                if (jsonNode.has("httpRequestAndHttpResponse")) {
                    jsonHttpRequest = jsonNode.get("httpRequestAndHttpResponse").toString();
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("exception while parsing [" + jsonHttpRequest + "] for HttpRequestAndHttpResponse", ex);
            }
        }
        HttpRequestAndHttpResponse httpRequestAndHttpResponse = null;
        try {
            HttpRequestAndHttpResponseDTO httpRequestDTO = (HttpRequestAndHttpResponseDTO)this.objectMapper.readValue(jsonHttpRequest, HttpRequestAndHttpResponseDTO.class);
            if (httpRequestDTO != null) {
                httpRequestAndHttpResponse = httpRequestDTO.buildObject();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("exception while parsing [" + jsonHttpRequest + "] for HttpRequestAndHttpResponse", ex);
        }
        return httpRequestAndHttpResponse;
    }

    @Override
    public Class<HttpRequestAndHttpResponse> supportsType() {
        return HttpRequestAndHttpResponse.class;
    }

    public HttpRequestAndHttpResponse[] deserializeArray(String jsonHttpRequests) {
        ArrayList<HttpRequestAndHttpResponse> httpRequests = new ArrayList<HttpRequestAndHttpResponse>();
        if (StringUtils.isBlank(jsonHttpRequests)) {
            throw new IllegalArgumentException("1 error:\n - a request or request array is required but value was \"" + jsonHttpRequests + "\"");
        }
        List<String> jsonRequestList = this.jsonArraySerializer.splitJSONArray(jsonHttpRequests);
        if (jsonRequestList.isEmpty()) {
            throw new IllegalArgumentException("1 error:\n - a request or array of request is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonRequest : jsonRequestList) {
            try {
                httpRequests.add(this.deserialize(jsonRequest));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + String.join((CharSequence)",\n", validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return httpRequests.toArray(new HttpRequestAndHttpResponse[0]);
    }
}

