/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.proxyconfiguration;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.xdev.mockserver.configuration.Configuration;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.util.StringUtils;

public final class ProxyConfiguration
extends ObjectWithJsonToString {
    private final Type type;
    private final InetSocketAddress proxyAddress;
    private final String username;
    private final String password;

    private ProxyConfiguration(Type type, InetSocketAddress proxyAddress, String username, String password) {
        this.type = type;
        this.proxyAddress = proxyAddress;
        this.username = username;
        this.password = password;
    }

    public static List<ProxyConfiguration> proxyConfiguration(Configuration configuration) {
        InetSocketAddress socksProxySocketAddress;
        ArrayList<ProxyConfiguration> proxyConfigurations = new ArrayList<ProxyConfiguration>();
        String username = configuration.forwardProxyAuthenticationUsername();
        String password = configuration.forwardProxyAuthenticationPassword();
        InetSocketAddress httpProxySocketAddress = configuration.forwardHttpProxy();
        if (httpProxySocketAddress != null) {
            proxyConfigurations.add(ProxyConfiguration.proxyConfiguration(Type.HTTP, httpProxySocketAddress, username, password));
        }
        if ((socksProxySocketAddress = configuration.forwardSocksProxy()) != null) {
            if (proxyConfigurations.isEmpty()) {
                proxyConfigurations.add(ProxyConfiguration.proxyConfiguration(Type.SOCKS5, socksProxySocketAddress, username, password));
            } else {
                throw new IllegalArgumentException("Invalid proxy configuration it is not possible to configure HTTP or HTTPS proxy at the same time as a SOCKS proxy, please choose either HTTP(S) proxy OR a SOCKS proxy");
            }
        }
        return proxyConfigurations;
    }

    public static ProxyConfiguration proxyConfiguration(Type type, String address) {
        return ProxyConfiguration.proxyConfiguration(type, address, null, null);
    }

    public static ProxyConfiguration proxyConfiguration(Type type, InetSocketAddress address) {
        return ProxyConfiguration.proxyConfiguration(type, address, null, null);
    }

    public static ProxyConfiguration proxyConfiguration(Type type, String address, String username, String password) {
        String[] addressParts = address.split(":");
        if (addressParts.length != 2) {
            throw new IllegalArgumentException("Proxy address must be in the format <host>:<ip>, for example 127.0.0.1:9090 or localhost:9090");
        }
        try {
            return ProxyConfiguration.proxyConfiguration(type, new InetSocketAddress(addressParts[0], Integer.parseInt(addressParts[1])), username, password);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Proxy address port \"" + addressParts[1] + "\" into an integer");
        }
    }

    public static ProxyConfiguration proxyConfiguration(Type type, InetSocketAddress address, String username, String password) {
        return new ProxyConfiguration(type, address, username, password);
    }

    public Type getType() {
        return this.type;
    }

    public InetSocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public ProxyConfiguration addProxyAuthenticationHeader(HttpRequest httpRequest) {
        if (StringUtils.isNotBlank(this.username) && StringUtils.isNotBlank(this.password)) {
            httpRequest.withHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString(), "Basic " + Base64.encode((ByteBuf)Unpooled.copiedBuffer((CharSequence)(this.username + ":" + this.password), (Charset)StandardCharsets.UTF_8), (boolean)false).toString(StandardCharsets.US_ASCII));
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProxyConfiguration)) {
            return false;
        }
        ProxyConfiguration that = (ProxyConfiguration)o;
        return this.getType() == that.getType() && Objects.equals(this.getProxyAddress(), that.getProxyAddress()) && Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getPassword(), that.getPassword());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getProxyAddress(), this.getUsername(), this.getPassword()});
    }

    public static enum Type {
        HTTP,
        SOCKS5;

    }
}

