/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.xdev.mockserver.model.BinaryBody;
import software.xdev.mockserver.model.Body;
import software.xdev.mockserver.model.Cookie;
import software.xdev.mockserver.model.Cookies;
import software.xdev.mockserver.model.Header;
import software.xdev.mockserver.model.Headers;
import software.xdev.mockserver.model.HttpMessage;
import software.xdev.mockserver.model.HttpRequestModifier;
import software.xdev.mockserver.model.MediaType;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.Parameter;
import software.xdev.mockserver.model.Parameters;
import software.xdev.mockserver.model.Protocol;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.model.SocketAddress;
import software.xdev.mockserver.model.StringBody;
import software.xdev.mockserver.util.StringUtils;

public class HttpRequest
extends RequestDefinition
implements HttpMessage<HttpRequest, Body> {
    private int hashCode;
    private NottableString method = NottableString.string("");
    private NottableString path = NottableString.string("");
    private Parameters pathParameters;
    private Parameters queryStringParameters;
    private Body body;
    private Headers headers;
    private Cookies cookies;
    private Boolean keepAlive;
    private Protocol protocol;
    private Integer streamId;
    private SocketAddress socketAddress;
    private String localAddress;
    private String remoteAddress;

    public static HttpRequest request() {
        return new HttpRequest();
    }

    public static HttpRequest request(String path) {
        return new HttpRequest().withPath(path);
    }

    public Boolean isKeepAlive() {
        return this.keepAlive;
    }

    public HttpRequest withKeepAlive(Boolean isKeepAlive) {
        this.keepAlive = isKeepAlive;
        this.hashCode = 0;
        return this;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public HttpRequest withProtocol(Protocol protocol) {
        this.protocol = protocol;
        this.hashCode = 0;
        return this;
    }

    public Integer getStreamId() {
        return this.streamId;
    }

    public HttpRequest withStreamId(Integer streamId) {
        this.streamId = streamId;
        this.hashCode = 0;
        return this;
    }

    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public HttpRequest withSocketAddress(SocketAddress socketAddress) {
        this.socketAddress = socketAddress;
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withSocketAddress(String host, Integer port, SocketAddress.Scheme scheme) {
        this.socketAddress = new SocketAddress().withHost(host).withPort(port).withScheme(scheme);
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withSocketAddressFromHostHeader() {
        this.withSocketAddress(this.getFirstHeader("host"), null);
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withSocketAddress(String host, Integer port) {
        if (StringUtils.isNotBlank(host)) {
            String[] hostParts = host.split(":");
            if (hostParts.length > 1) {
                this.withSocketAddress(hostParts[0], port != null ? port : Integer.parseInt(hostParts[1]), SocketAddress.Scheme.HTTP);
            } else {
                this.withSocketAddress(host, port != null ? port : 80, SocketAddress.Scheme.HTTP);
            }
        }
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withLocalAddress(String localAddress) {
        this.localAddress = localAddress;
        this.hashCode = 0;
        return this;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public HttpRequest withRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        this.hashCode = 0;
        return this;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public HttpRequest withMethod(String method) {
        return this.withMethod(NottableString.string(method));
    }

    public HttpRequest withMethod(NottableString method) {
        this.method = method;
        this.hashCode = 0;
        return this;
    }

    public NottableString getMethod() {
        return this.method;
    }

    public String getMethod(String defaultValue) {
        if (StringUtils.isBlank(this.method.getValue())) {
            return defaultValue;
        }
        return this.method.getValue();
    }

    public HttpRequest withPath(String path) {
        this.withPath(NottableString.string(path));
        return this;
    }

    public HttpRequest withPath(NottableString path) {
        this.path = path;
        this.hashCode = 0;
        return this;
    }

    public NottableString getPath() {
        return this.path;
    }

    public boolean matches(String method) {
        return this.method.getValue().equals(method);
    }

    public boolean matches(String method, String ... paths) {
        if (!this.matches(method)) {
            return false;
        }
        return this.matchesPath(paths);
    }

    public boolean matchesPath(String ... paths) {
        boolean matches = false;
        for (String path : paths) {
            matches = this.path.getValue().equals(path);
            if (matches) break;
        }
        return matches;
    }

    public Parameters getPathParameters() {
        return this.pathParameters;
    }

    private Parameters getOrCreatePathParameters() {
        if (this.pathParameters == null) {
            this.pathParameters = new Parameters(new Parameter[0]);
            this.hashCode = 0;
        }
        return this.pathParameters;
    }

    public HttpRequest withPathParameters(Parameters parameters) {
        this.pathParameters = parameters == null || parameters.isEmpty() ? null : parameters;
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withPathParameters(List<Parameter> parameters) {
        this.getOrCreatePathParameters().withEntries(parameters);
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withPathParameters(Parameter ... parameters) {
        this.getOrCreatePathParameters().withEntries(parameters);
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withPathParameters(Map<String, List<String>> parameters) {
        this.getOrCreatePathParameters().withEntries(parameters);
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withPathParameter(Parameter parameter) {
        this.getOrCreatePathParameters().withEntry(parameter);
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withPathParameter(String name, String ... values) {
        String[] stringArray;
        Parameters parameters = this.getOrCreatePathParameters();
        if (values.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ".*";
        } else {
            stringArray = values;
        }
        parameters.withEntry(name, stringArray);
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withPathParameter(NottableString name, NottableString ... values) {
        NottableString[] nottableStringArray;
        Parameters parameters = this.getOrCreatePathParameters();
        if (values.length == 0) {
            NottableString[] nottableStringArray2 = new NottableString[1];
            nottableStringArray = nottableStringArray2;
            nottableStringArray2[0] = NottableString.string(".*");
        } else {
            nottableStringArray = values;
        }
        parameters.withEntry(name, nottableStringArray);
        this.hashCode = 0;
        return this;
    }

    public List<Parameter> getPathParameterList() {
        if (this.pathParameters != null) {
            return this.pathParameters.getEntries();
        }
        return Collections.emptyList();
    }

    public boolean hasPathParameter(String name, String value) {
        if (this.pathParameters != null) {
            return this.pathParameters.containsEntry(name, value);
        }
        return false;
    }

    public boolean hasPathParameter(NottableString name, NottableString value) {
        if (this.pathParameters != null) {
            return this.pathParameters.containsEntry(name, value);
        }
        return false;
    }

    public String getFirstPathParameter(String name) {
        if (this.pathParameters != null) {
            return this.pathParameters.getFirstValue(name);
        }
        return "";
    }

    public Parameters getQueryStringParameters() {
        return this.queryStringParameters;
    }

    private Parameters getOrCreateQueryStringParameters() {
        if (this.queryStringParameters == null) {
            this.queryStringParameters = new Parameters(new Parameter[0]);
            this.hashCode = 0;
        }
        return this.queryStringParameters;
    }

    public HttpRequest withQueryStringParameters(Parameters parameters) {
        this.queryStringParameters = parameters == null || parameters.isEmpty() ? null : parameters;
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withQueryStringParameters(List<Parameter> parameters) {
        this.getOrCreateQueryStringParameters().withEntries(parameters);
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withQueryStringParameters(Parameter ... parameters) {
        this.getOrCreateQueryStringParameters().withEntries(parameters);
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withQueryStringParameters(Map<String, List<String>> parameters) {
        this.getOrCreateQueryStringParameters().withEntries(parameters);
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withQueryStringParameter(Parameter parameter) {
        this.getOrCreateQueryStringParameters().withEntry(parameter);
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withQueryStringParameter(String name, String ... values) {
        this.getOrCreateQueryStringParameters().withEntry(name, values);
        this.hashCode = 0;
        return this;
    }

    public HttpRequest withQueryStringParameter(NottableString name, NottableString ... values) {
        NottableString[] nottableStringArray;
        Parameters parameters = this.getOrCreateQueryStringParameters();
        if (values.length == 0) {
            NottableString[] nottableStringArray2 = new NottableString[1];
            nottableStringArray = nottableStringArray2;
            nottableStringArray2[0] = NottableString.string(".*");
        } else {
            nottableStringArray = values;
        }
        parameters.withEntry(name, nottableStringArray);
        this.hashCode = 0;
        return this;
    }

    public List<Parameter> getQueryStringParameterList() {
        if (this.queryStringParameters != null) {
            return this.queryStringParameters.getEntries();
        }
        return Collections.emptyList();
    }

    public boolean hasQueryStringParameter(String name, String value) {
        if (this.queryStringParameters != null) {
            return this.queryStringParameters.containsEntry(name, value);
        }
        return false;
    }

    public boolean hasQueryStringParameter(NottableString name, NottableString value) {
        if (this.queryStringParameters != null) {
            return this.queryStringParameters.containsEntry(name, value);
        }
        return false;
    }

    public String getFirstQueryStringParameter(String name) {
        if (this.queryStringParameters != null) {
            return this.queryStringParameters.getFirstValue(name);
        }
        return "";
    }

    @Override
    public HttpRequest withBody(String body) {
        this.body = new StringBody(body);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withBody(String body, Charset charset) {
        if (body != null) {
            this.body = new StringBody(body, charset);
            this.hashCode = 0;
        }
        return this;
    }

    @Override
    public HttpRequest withBody(byte[] body) {
        this.body = new BinaryBody(body);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withBody(Body body) {
        this.body = body;
        this.hashCode = 0;
        return this;
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    @JsonIgnore
    public byte[] getBodyAsRawBytes() {
        return this.body != null ? this.body.getRawBytes() : new byte[]{};
    }

    @Override
    @JsonIgnore
    public String getBodyAsString() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    @JsonIgnore
    public String getBodyAsJsonOrXmlString() {
        if (this.body != null) {
            if (this.body instanceof StringBody) {
                return new String(this.body.toString().getBytes(MediaType.parse(this.getFirstHeader(HttpHeaderNames.CONTENT_TYPE.toString())).getCharsetOrDefault()), StandardCharsets.UTF_8);
            }
            return this.getBodyAsString();
        }
        return null;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    private Headers getOrCreateHeaders() {
        if (this.headers == null) {
            this.headers = new Headers(new Header[0]);
            this.hashCode = 0;
        }
        return this.headers;
    }

    @Override
    public HttpRequest withHeaders(Headers headers) {
        this.headers = headers == null || headers.isEmpty() ? null : headers;
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withHeaders(List<Header> headers) {
        this.getOrCreateHeaders().withEntries(headers);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withHeaders(Header ... headers) {
        this.getOrCreateHeaders().withEntries(headers);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withHeader(Header header) {
        this.getOrCreateHeaders().withEntry(header);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withHeader(String name, String ... values) {
        String[] stringArray;
        Headers headers = this.getOrCreateHeaders();
        if (values.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ".*";
        } else {
            stringArray = values;
        }
        headers.withEntry(Header.header(name, stringArray));
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withHeader(NottableString name, NottableString ... values) {
        NottableString[] nottableStringArray;
        Headers headers = this.getOrCreateHeaders();
        if (values.length == 0) {
            NottableString[] nottableStringArray2 = new NottableString[1];
            nottableStringArray = nottableStringArray2;
            nottableStringArray2[0] = NottableString.string(".*");
        } else {
            nottableStringArray = values;
        }
        headers.withEntry(Header.header(name, nottableStringArray));
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withContentType(MediaType mediaType) {
        this.getOrCreateHeaders().withEntry(Header.header(HttpHeaderNames.CONTENT_TYPE.toString(), mediaType.toString()));
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest replaceHeader(Header header) {
        this.getOrCreateHeaders().replaceEntry(header);
        this.hashCode = 0;
        return this;
    }

    @Override
    public List<Header> getHeaderList() {
        if (this.headers != null) {
            return this.headers.getEntries();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getHeader(String name) {
        if (this.headers != null) {
            return this.headers.getValues(name);
        }
        return Collections.emptyList();
    }

    @Override
    public String getFirstHeader(String name) {
        if (this.headers != null) {
            return this.headers.getFirstValue(name);
        }
        return "";
    }

    @Override
    public boolean containsHeader(String name) {
        if (this.headers != null) {
            return this.headers.containsEntry(name);
        }
        return false;
    }

    public boolean containsHeader(String name, String value) {
        if (this.headers != null) {
            return this.headers.containsEntry(name, value);
        }
        return false;
    }

    @Override
    public HttpRequest removeHeader(String name) {
        if (this.headers != null) {
            this.headers.remove(name);
            this.hashCode = 0;
        }
        return this;
    }

    @Override
    public HttpRequest removeHeader(NottableString name) {
        if (this.headers != null) {
            this.headers.remove(name);
            this.hashCode = 0;
        }
        return this;
    }

    @Override
    public Cookies getCookies() {
        return this.cookies;
    }

    private Cookies getOrCreateCookies() {
        if (this.cookies == null) {
            this.cookies = new Cookies(new Cookie[0]);
            this.hashCode = 0;
        }
        return this.cookies;
    }

    @Override
    public HttpRequest withCookies(Cookies cookies) {
        this.cookies = cookies == null || cookies.isEmpty() ? null : cookies;
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withCookies(List<Cookie> cookies) {
        this.getOrCreateCookies().withEntries(cookies);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withCookies(Cookie ... cookies) {
        this.getOrCreateCookies().withEntries(cookies);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withCookie(Cookie cookie) {
        this.getOrCreateCookies().withEntry(cookie);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withCookie(String name, String value) {
        this.getOrCreateCookies().withEntry(name, value);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpRequest withCookie(NottableString name, NottableString value) {
        this.getOrCreateCookies().withEntry(name, value);
        this.hashCode = 0;
        return this;
    }

    @Override
    public List<Cookie> getCookieList() {
        if (this.cookies != null) {
            return this.cookies.getEntries();
        }
        return Collections.emptyList();
    }

    public InetSocketAddress socketAddressFromHostHeader() {
        if (this.socketAddress != null && this.socketAddress.getHost() != null) {
            boolean isSsl = this.socketAddress.getScheme() != null && this.socketAddress.getScheme().equals((Object)SocketAddress.Scheme.HTTPS);
            return new InetSocketAddress(this.socketAddress.getHost(), this.socketAddress.getPort() != null ? this.socketAddress.getPort() : (isSsl ? 443 : 80));
        }
        if (StringUtils.isNotBlank(this.getFirstHeader(HttpHeaderNames.HOST.toString()))) {
            String[] hostHeaderParts = this.getFirstHeader(HttpHeaderNames.HOST.toString()).split(":");
            return new InetSocketAddress(hostHeaderParts[0], hostHeaderParts.length > 1 ? Integer.parseInt(hostHeaderParts[1]) : 80);
        }
        throw new IllegalArgumentException("Host header must be provided to determine remote socket address, the request does not include the \"Host\" header:\n" + String.valueOf(this));
    }

    @Override
    public HttpRequest shallowClone() {
        return HttpRequest.not(HttpRequest.request(), this.not).withMethod(this.method).withPath(this.path).withPathParameters(this.pathParameters).withQueryStringParameters(this.queryStringParameters).withBody(this.body).withHeaders(this.headers).withCookies(this.cookies).withKeepAlive(this.keepAlive).withProtocol(this.protocol).withStreamId(this.streamId).withSocketAddress(this.socketAddress).withLocalAddress(this.localAddress).withRemoteAddress(this.remoteAddress);
    }

    public HttpRequest clone() {
        return HttpRequest.not(HttpRequest.request(), this.not).withMethod(this.method).withPath(this.path).withPathParameters(this.pathParameters != null ? this.pathParameters.clone() : null).withQueryStringParameters(this.queryStringParameters != null ? this.queryStringParameters.clone() : null).withBody(this.body).withHeaders(this.headers != null ? this.headers.clone() : null).withCookies(this.cookies != null ? this.cookies.clone() : null).withKeepAlive(this.keepAlive).withProtocol(this.protocol).withStreamId(this.streamId).withSocketAddress(this.socketAddress).withLocalAddress(this.localAddress).withRemoteAddress(this.remoteAddress);
    }

    public HttpRequest update(HttpRequest requestOverride, HttpRequestModifier requestModifier) {
        if (requestOverride != null) {
            if (requestOverride.getMethod() != null && StringUtils.isNotBlank(requestOverride.getMethod().getValue())) {
                this.withMethod(requestOverride.getMethod());
            }
            if (requestOverride.getPath() != null && StringUtils.isNotBlank(requestOverride.getPath().getValue())) {
                this.withPath(requestOverride.getPath());
            }
            for (Parameter parameter : requestOverride.getPathParameterList()) {
                this.getOrCreatePathParameters().replaceEntry(parameter);
            }
            for (Parameter parameter : requestOverride.getQueryStringParameterList()) {
                this.getOrCreateQueryStringParameters().replaceEntry(parameter);
            }
            if (requestOverride.getBody() != null) {
                this.withBody(requestOverride.getBody());
            }
            for (Header header : requestOverride.getHeaderList()) {
                this.getOrCreateHeaders().replaceEntry(header);
            }
            for (Cookie cookie : requestOverride.getCookieList()) {
                this.withCookie(cookie);
            }
            if (requestOverride.getProtocol() != null) {
                this.withProtocol(requestOverride.getProtocol());
            }
            if (requestOverride.getStreamId() != null) {
                this.withStreamId(requestOverride.getStreamId());
            }
            if (requestOverride.isKeepAlive() != null) {
                this.withKeepAlive(requestOverride.isKeepAlive());
            }
            if (requestOverride.getSocketAddress() != null) {
                this.withSocketAddress(requestOverride.getSocketAddress());
            }
            this.hashCode = 0;
        }
        if (requestModifier != null) {
            if (requestModifier.getPath() != null) {
                this.withPath(requestModifier.getPath().update(this.getPath()));
            }
            if (requestModifier.getQueryStringParameters() != null) {
                this.withQueryStringParameters(requestModifier.getQueryStringParameters().update(this.getQueryStringParameters()));
            }
            if (requestModifier.getHeaders() != null) {
                this.withHeaders(requestModifier.getHeaders().update(this.getHeaders()));
            }
            if (requestModifier.getCookies() != null) {
                this.withCookies(requestModifier.getCookies().update(this.getCookies()));
            }
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.path, that.path) && Objects.equals(this.pathParameters, that.pathParameters) && Objects.equals(this.queryStringParameters, that.queryStringParameters) && Objects.equals(this.body, that.body) && Objects.equals(this.headers, that.headers) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.keepAlive, that.keepAlive) && Objects.equals((Object)this.protocol, (Object)that.protocol) && Objects.equals(this.streamId, that.streamId) && Objects.equals(this.socketAddress, that.socketAddress) && Objects.equals(this.localAddress, that.localAddress) && Objects.equals(this.remoteAddress, that.remoteAddress);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(new Object[]{super.hashCode(), this.method, this.path, this.pathParameters, this.queryStringParameters, this.body, this.headers, this.cookies, this.keepAlive, this.protocol, this.streamId, this.socketAddress, this.localAddress, this.remoteAddress});
        }
        return this.hashCode;
    }
}

