/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Objects;
import software.xdev.mockserver.model.Action;

public class HttpError
extends Action<HttpError> {
    private int hashCode;
    private Boolean dropConnection;
    private byte[] responseBytes;

    public static HttpError error() {
        return new HttpError();
    }

    public HttpError withDropConnection(Boolean dropConnection) {
        this.dropConnection = dropConnection;
        this.hashCode = 0;
        return this;
    }

    public Boolean getDropConnection() {
        return this.dropConnection;
    }

    public HttpError withResponseBytes(byte[] responseBytes) {
        this.responseBytes = responseBytes;
        this.hashCode = 0;
        return this;
    }

    public byte[] getResponseBytes() {
        return this.responseBytes;
    }

    @Override
    @JsonIgnore
    public Action.Type getType() {
        return Action.Type.ERROR;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpError httpError = (HttpError)o;
        return Objects.equals(this.dropConnection, httpError.dropConnection) && Arrays.equals(this.responseBytes, httpError.responseBytes);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int result = Objects.hash(super.hashCode(), this.dropConnection);
            this.hashCode = 31 * result + Arrays.hashCode(this.responseBytes);
        }
        return this.hashCode;
    }
}

