/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.filters;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import software.xdev.mockserver.model.Header;
import software.xdev.mockserver.model.Headers;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;

public class HopByHopHeaderFilter {
    private static final List<String> REQUEST_HEADERS_TO_REMOVE = Arrays.asList("proxy-connection", "connection", "keep-alive", "transfer-encoding", "te", "trailer", "proxy-authorization", "proxy-authenticate", "upgrade");
    private static final List<String> RESPONSE_HEADERS_TO_REMOVE = Arrays.asList("proxy-connection", "connection", "keep-alive", "transfer-encoding", "content-length", "te", "trailer", "upgrade");

    public HttpRequest onRequest(HttpRequest request) {
        if (request == null) {
            return null;
        }
        Headers headers = new Headers(new Header[0]);
        for (Header header : request.getHeaderList()) {
            if (REQUEST_HEADERS_TO_REMOVE.contains(header.getName().getValue().toLowerCase(Locale.ENGLISH))) continue;
            headers.withEntry(header);
        }
        HttpRequest clonedRequest = request.clone();
        if (!headers.isEmpty()) {
            clonedRequest.withHeaders(headers);
        }
        return clonedRequest;
    }

    public HttpResponse onResponse(HttpResponse response) {
        if (response == null) {
            return null;
        }
        Headers headers = new Headers(new Header[0]);
        for (Header header : response.getHeaderList()) {
            if (RESPONSE_HEADERS_TO_REMOVE.contains(header.getName().getValue().toLowerCase(Locale.ENGLISH))) continue;
            headers.withEntry(header);
        }
        HttpResponse clonedResponse = response.clone();
        if (!headers.isEmpty()) {
            clonedResponse.withHeaders(headers);
        }
        return clonedResponse;
    }
}

